/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;

public class InstanceOfDataTypeCheck
implements ISearchOperation {
    private int position;
    private EDataType dataType;

    public InstanceOfDataTypeCheck(int position, EDataType dataType) {
        this.position = position;
        this.dataType = dataType;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     " + this.dataType.getName() + "(+" + variableMapping.apply(this.position) + ")";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position);
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            Objects.requireNonNull(frame.getValue(InstanceOfDataTypeCheck.this.position), () -> String.format("Invalid plan, variable %s unbound", InstanceOfDataTypeCheck.this.position));
            return InstanceOfDataTypeCheck.this.dataType.isInstance(frame.getValue(InstanceOfDataTypeCheck.this.position));
        }

        @Override
        public ISearchOperation getOperation() {
            return InstanceOfDataTypeCheck.this;
        }
    }
}

