/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.events.IAncestorListener;
import org.eclipse.wb.draw2d.events.IFigureListener;
import org.eclipse.wb.draw2d.events.IMouseListener;
import org.eclipse.wb.draw2d.events.IMouseMoveListener;
import org.eclipse.wb.draw2d.events.IMouseTrackListener;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.FigureVisitor;
import org.eclipse.wb.internal.draw2d.ICustomTooltipProvider;
import org.eclipse.wb.internal.draw2d.events.AncestorEventTable;
import org.eclipse.wb.internal.draw2d.events.EventTable;

public class Figure {
    private EventTable m_eventTable;
    private AncestorEventTable m_ancestorEventTable;
    private Figure m_parent;
    private final Rectangle m_bounds = new Rectangle();
    private List<Figure> m_children;
    private Border m_border;
    private Color m_background;
    private Color m_foreground;
    private Font m_font = Display.getCurrent().getSystemFont();
    private Cursor m_cursor;
    private boolean m_opaque;
    private boolean m_visible = true;
    private Object m_data;
    private String m_toolTipText;
    private ICustomTooltipProvider m_customTooltipProvider;

    public void addMouseListener(IMouseListener listener) {
        this.getEnsureEventTable().addListener(IMouseListener.class, listener);
    }

    public void removeMouseListener(IMouseListener listener) {
        this.getEnsureEventTable().removeListener(IMouseListener.class, listener);
    }

    public void addMouseMoveListener(IMouseMoveListener listener) {
        this.getEnsureEventTable().addListener(IMouseMoveListener.class, listener);
    }

    public void removeMouseMoveListener(IMouseMoveListener listener) {
        this.getEnsureEventTable().removeListener(IMouseMoveListener.class, listener);
    }

    public void addMouseTrackListener(IMouseTrackListener listener) {
        this.getEnsureEventTable().addListener(IMouseTrackListener.class, listener);
    }

    public void removeMouseTrackListener(IMouseTrackListener listener) {
        this.getEnsureEventTable().removeListener(IMouseTrackListener.class, listener);
    }

    public void addAncestorListener(IAncestorListener listener) {
        if (this.m_ancestorEventTable == null) {
            this.m_ancestorEventTable = new AncestorEventTable(this);
        }
        this.m_ancestorEventTable.addAncestorListener(listener);
    }

    public void removeAncestorListener(IAncestorListener listener) {
        if (this.m_ancestorEventTable != null) {
            this.m_ancestorEventTable.removeAncestorListener(listener);
            if (this.m_ancestorEventTable.isEmpty()) {
                this.m_ancestorEventTable.unhookFigure();
                this.m_ancestorEventTable = null;
            }
        }
    }

    public void addFigureListener(IFigureListener listener) {
        this.getEnsureEventTable().addListener(IFigureListener.class, listener);
    }

    public void removeFigureListener(IFigureListener listener) {
        this.getEnsureEventTable().removeListener(IFigureListener.class, listener);
    }

    public <T> List<T> getListeners(Class<T> listenerClass) {
        return this.m_eventTable == null ? null : this.m_eventTable.getListeners(listenerClass);
    }

    private EventTable getEnsureEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventTable();
        }
        return this.m_eventTable;
    }

    private void fireMoved() {
        List<IFigureListener> listeners = this.getListeners(IFigureListener.class);
        if (listeners != null) {
            for (IFigureListener figureListener : listeners) {
                figureListener.figureMoved(this);
            }
        }
    }

    private void fireReparent(Figure oldParent, Figure newParent) {
        List<IFigureListener> listeners = this.getListeners(IFigureListener.class);
        if (listeners != null) {
            for (IFigureListener figureListener : listeners) {
                figureListener.figureReparent(this, oldParent, newParent);
            }
        }
    }

    protected void addNotify() {
        for (Figure childFigure : this.getChildren()) {
            childFigure.addNotify();
        }
    }

    protected void removeNotify() {
        for (Figure childFigure : this.getChildren()) {
            childFigure.removeNotify();
        }
    }

    public final void accept(FigureVisitor visitor, boolean forward) {
        if (visitor.visit(this)) {
            List<Figure> children = this.getChildren();
            int size = children.size();
            if (forward) {
                int i = 0;
                while (i < size) {
                    Figure childFigure = children.get(i);
                    childFigure.accept(visitor, forward);
                    ++i;
                }
            } else {
                int i = size - 1;
                while (i >= 0) {
                    Figure childFigure = children.get(i);
                    childFigure.accept(visitor, forward);
                    --i;
                }
            }
            visitor.endVisit(this);
        }
    }

    public void add(Figure childFigure) {
        this.add(childFigure, null, -1);
    }

    public void add(Figure childFigure, int index) {
        this.add(childFigure, null, index);
    }

    public void add(Figure childFigure, Rectangle bounds) {
        this.add(childFigure, bounds, -1);
    }

    public void add(Figure childFigure, Rectangle bounds, int index) {
        if (childFigure.getParent() != null) {
            throw new IllegalArgumentException("Figure.add(...) Figure already added to parent");
        }
        Figure f = this;
        while (f != null) {
            if (childFigure == f) {
                throw new IllegalArgumentException("IWAG0002E Figure.add(...) Cycle created in figure heirarchy");
            }
            f = f.getParent();
        }
        if (this.m_children == null) {
            this.m_children = Lists.newArrayList();
        }
        if (index < -1 || index > this.m_children.size()) {
            throw new IndexOutOfBoundsException("IWAG0001E Figure.add(...) invalid index");
        }
        if (index == -1) {
            this.m_children.add(childFigure);
        } else {
            this.m_children.add(index, childFigure);
        }
        childFigure.setParent(this);
        childFigure.addNotify();
        if (bounds != null) {
            childFigure.setBounds(bounds);
        }
        this.resetState(childFigure);
    }

    public List<Figure> getChildren() {
        return this.m_children == null ? Collections.emptyList() : this.m_children;
    }

    public void remove(Figure childFigure) {
        if (this.m_children == null || this.m_children.isEmpty()) {
            throw new IllegalArgumentException("This parent is empty");
        }
        if (childFigure.getParent() != this || !this.m_children.contains(childFigure)) {
            throw new IllegalArgumentException("IWAG0003E Figure is not a child of this parent");
        }
        childFigure.removeNotify();
        this.m_children.remove(childFigure);
        childFigure.setParent(null);
        this.resetState(childFigure);
    }

    public void removeAll() {
        for (Figure childFigure : this.getChildren()) {
            childFigure.removeNotify();
            childFigure.setParent(null);
        }
        if (this.m_children != null && !this.m_children.isEmpty()) {
            this.resetState();
        }
        this.m_children = null;
    }

    public FigureCanvas getFigureCanvas() {
        return this.m_parent.getFigureCanvas();
    }

    public Figure getParent() {
        return this.m_parent;
    }

    public void setParent(Figure parent) {
        Figure oldParent = this.m_parent;
        this.m_parent = parent;
        this.fireReparent(oldParent, this.m_parent);
    }

    protected void updateCursor() {
        Figure parent = this.getParent();
        if (parent != null && this.isVisible()) {
            parent.updateCursor();
        }
    }

    protected final void setCapture(boolean capture) {
        if (capture) {
            this.setCapture(this);
        } else {
            this.setCapture(null);
        }
    }

    public void setCapture(Figure figure) {
        Figure parent = this.getParent();
        if (parent != null) {
            parent.setCapture(figure);
        }
    }

    public final void resetState() {
        this.resetState(this.getBounds());
    }

    public final void resetState(Rectangle area) {
        if (this.isVisible()) {
            this.repaint(true, area.x, area.y, area.width, area.height);
        }
    }

    protected final void resetState(Figure childFigure) {
        if (this.isVisible() && childFigure.isVisible()) {
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            Rectangle childBounds = childFigure.getBounds();
            this.repaint(true, bounds.x + insets.left + childBounds.x, bounds.y + insets.top + childBounds.y, childBounds.width, childBounds.height);
        }
    }

    public final void repaint() {
        if (this.isVisible()) {
            Rectangle bounds = this.getBounds();
            this.repaint(false, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    protected void repaint(boolean reset, int x, int y, int width, int height) {
        Figure parent = this.getParent();
        if (parent != null) {
            Rectangle bounds = parent.getBounds();
            Insets insets = parent.getInsets();
            parent.repaint(reset, bounds.x + insets.left + x, bounds.y + insets.top + y, width, height);
        }
    }

    public final void paint(Graphics graphics) {
        if (this.m_background != null) {
            graphics.setBackgroundColor(this.m_background);
        }
        if (this.m_foreground != null) {
            graphics.setForegroundColor(this.m_foreground);
        }
        if (this.m_font != null) {
            graphics.setFont(this.m_font);
        }
        graphics.pushState();
        try {
            this.paintFigure(graphics);
            this.paintChildren(graphics);
            this.paintBorder(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    private void paintFigure(Graphics graphics) {
        if (this.m_opaque) {
            Rectangle bounds = this.getBounds();
            graphics.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        this.paintClientArea(graphics);
        graphics.restoreState();
    }

    private void paintChildren(Graphics graphics) {
        List<Figure> children = this.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        graphics.pushState();
        for (Figure childFigure : children) {
            if (!childFigure.isVisible() || !childFigure.intersects(graphics.getClip())) continue;
            Rectangle childBounds = childFigure.getBounds();
            graphics.clipRect(childBounds);
            graphics.translate(childBounds.x, childBounds.y);
            childFigure.paint(graphics);
            graphics.restoreState();
        }
        graphics.popState();
        graphics.restoreState();
    }

    protected void paintClientArea(Graphics graphics) {
    }

    protected void paintBorder(Graphics graphics) {
        if (this.m_border != null) {
            this.m_border.paint(this, graphics);
        }
    }

    public Point getLocation() {
        return this.m_bounds.getLocation();
    }

    public Dimension getSize() {
        return this.m_bounds.getSize();
    }

    public Rectangle getBounds() {
        return this.m_bounds;
    }

    public void setLocation(int x, int y) {
        if (this.m_bounds.x != x || this.m_bounds.y != y) {
            this.setBounds(new Rectangle(this.getBounds()).setLocation(x, y));
        }
    }

    public void setLocation(Point location) {
        this.setLocation(location.x, location.y);
    }

    public void setSize(int width, int height) {
        if (this.m_bounds.width != width || this.m_bounds.height != height) {
            this.setBounds(new Rectangle(this.getBounds()).setSize(width, height));
        }
    }

    public void setSize(Dimension size) {
        this.setSize(size.width, size.height);
    }

    public void setBounds(Rectangle bounds) {
        if (!this.m_bounds.equals(bounds)) {
            Rectangle dirtyArea = this.m_bounds.getUnion(bounds);
            this.m_bounds.setBounds(bounds);
            this.fireMoved();
            this.resetState(dirtyArea);
        }
    }

    public Insets getInsets() {
        if (this.m_border == null) {
            return IFigure.NO_INSETS;
        }
        return this.m_border.getInsets();
    }

    public Rectangle getClientArea() {
        return this.getClientArea(new Rectangle());
    }

    public Rectangle getClientArea(Rectangle rectangle) {
        rectangle.setBounds(this.getBounds());
        rectangle.crop(this.getInsets());
        rectangle.setLocation(0, 0);
        return rectangle;
    }

    public boolean intersects(Rectangle rectangle) {
        return this.getBounds().intersects(rectangle);
    }

    public boolean containsPoint(Point point) {
        return this.containsPoint(point.x, point.y);
    }

    public boolean containsPoint(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public Border getBorder() {
        return this.m_border;
    }

    public void setBorder(Border border) {
        if (this.m_border != border) {
            this.m_border = border;
            this.resetState();
        }
    }

    public Color getBackground() {
        return this.m_background;
    }

    public void setBackground(Color background) {
        if (this.m_background != background) {
            this.m_background = background;
            this.repaint();
        }
    }

    public Color getForeground() {
        return this.m_foreground;
    }

    public void setForeground(Color foreground) {
        if (this.m_foreground != foreground) {
            this.m_foreground = foreground;
            this.repaint();
        }
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        if (this.m_font != font) {
            this.m_font = font;
            this.resetState();
        }
    }

    public Cursor getCursor() {
        return this.m_cursor;
    }

    public void setCursor(Cursor cursor) {
        if (this.m_cursor != cursor) {
            this.m_cursor = cursor;
            this.updateCursor();
        }
    }

    public boolean isOpaque() {
        return this.m_opaque;
    }

    public void setOpaque(boolean opaque) {
        if (this.m_opaque != opaque) {
            this.m_opaque = opaque;
            this.repaint();
        }
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public void setVisible(boolean visible) {
        if (this.m_visible != visible) {
            this.resetState();
            this.m_visible = visible;
            this.resetState();
        }
    }

    public String getToolTipText() {
        return this.m_toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.m_toolTipText = toolTipText;
    }

    public ICustomTooltipProvider getCustomTooltipProvider() {
        return this.m_customTooltipProvider;
    }

    public void setCustomTooltipProvider(ICustomTooltipProvider provider) {
        this.m_customTooltipProvider = provider;
    }
}

