/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.util;

import java.io.IOException;
import java.io.Reader;

public class SequenceReader
extends Reader {
    private Reader[] fReaders;
    private Reader fCurrentReader;

    public SequenceReader(Reader[] readers) {
        this.fReaders = readers;
        if (this.fReaders.length > 0) {
            this.fCurrentReader = this.fReaders[0];
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fCurrentReader != null) {
            int i = 0;
            while (i <= this.indexOf(this.fCurrentReader)) {
                this.fReaders[i].close();
                ++i;
            }
        }
    }

    private int indexOf(Reader r) {
        int i = 0;
        while (i < this.fReaders.length) {
            if (this.fReaders[i] == r) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.fCurrentReader != null) {
            int bufIndex = off;
            int read = 0;
            bufIndex = off;
            while (bufIndex - off < len) {
                int c = this.primRead();
                if (c != -1) {
                    ++read;
                    cbuf[bufIndex] = (char)c;
                } else if (read == 0) {
                    return -1;
                }
                ++bufIndex;
            }
            return read;
        }
        return -1;
    }

    private int primRead() {
        int index;
        int c = -1;
        try {
            c = this.fCurrentReader.read();
        }
        catch (IOException iOException) {}
        if (c == -1 && (index = this.indexOf(this.fCurrentReader)) > -1 && index < this.fReaders.length - 1) {
            this.fCurrentReader = this.fReaders[index + 1];
            c = this.primRead();
        }
        return c;
    }
}

