/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Device;

final class ImmutableDevice
implements Device {
    @Nullable
    private final String pathOnHost;
    @Nullable
    private final String pathInContainer;
    @Nullable
    private final String cgroupPermissions;

    private ImmutableDevice(@Nullable String pathOnHost, @Nullable String pathInContainer, @Nullable String cgroupPermissions) {
        this.pathOnHost = pathOnHost;
        this.pathInContainer = pathInContainer;
        this.cgroupPermissions = cgroupPermissions;
    }

    @Override
    @JsonProperty(value="PathOnHost")
    @Nullable
    public String pathOnHost() {
        return this.pathOnHost;
    }

    @Override
    @JsonProperty(value="PathInContainer")
    @Nullable
    public String pathInContainer() {
        return this.pathInContainer;
    }

    @Override
    @JsonProperty(value="CgroupPermissions")
    @Nullable
    public String cgroupPermissions() {
        return this.cgroupPermissions;
    }

    public final ImmutableDevice withPathOnHost(@Nullable String value) {
        if (Objects.equals(this.pathOnHost, value)) {
            return this;
        }
        return new ImmutableDevice(value, this.pathInContainer, this.cgroupPermissions);
    }

    public final ImmutableDevice withPathInContainer(@Nullable String value) {
        if (Objects.equals(this.pathInContainer, value)) {
            return this;
        }
        return new ImmutableDevice(this.pathOnHost, value, this.cgroupPermissions);
    }

    public final ImmutableDevice withCgroupPermissions(@Nullable String value) {
        if (Objects.equals(this.cgroupPermissions, value)) {
            return this;
        }
        return new ImmutableDevice(this.pathOnHost, this.pathInContainer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDevice && this.equalTo((ImmutableDevice)another);
    }

    private boolean equalTo(ImmutableDevice another) {
        return Objects.equals(this.pathOnHost, another.pathOnHost) && Objects.equals(this.pathInContainer, another.pathInContainer) && Objects.equals(this.cgroupPermissions, another.cgroupPermissions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pathOnHost);
        h += (h << 5) + Objects.hashCode(this.pathInContainer);
        h += (h << 5) + Objects.hashCode(this.cgroupPermissions);
        return h;
    }

    public String toString() {
        return "Device{pathOnHost=" + this.pathOnHost + ", pathInContainer=" + this.pathInContainer + ", cgroupPermissions=" + this.cgroupPermissions + "}";
    }

    public static ImmutableDevice copyOf(Device instance) {
        if (instance instanceof ImmutableDevice) {
            return (ImmutableDevice)instance;
        }
        return ImmutableDevice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements Device.Builder {
        private String pathOnHost;
        private String pathInContainer;
        private String cgroupPermissions;

        private Builder() {
        }

        public final Builder from(Device instance) {
            String cgroupPermissionsValue;
            String pathInContainerValue;
            Objects.requireNonNull(instance, "instance");
            String pathOnHostValue = instance.pathOnHost();
            if (pathOnHostValue != null) {
                this.pathOnHost(pathOnHostValue);
            }
            if ((pathInContainerValue = instance.pathInContainer()) != null) {
                this.pathInContainer(pathInContainerValue);
            }
            if ((cgroupPermissionsValue = instance.cgroupPermissions()) != null) {
                this.cgroupPermissions(cgroupPermissionsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="PathOnHost")
        public final Builder pathOnHost(@Nullable String pathOnHost) {
            this.pathOnHost = pathOnHost;
            return this;
        }

        @Override
        @JsonProperty(value="PathInContainer")
        public final Builder pathInContainer(@Nullable String pathInContainer) {
            this.pathInContainer = pathInContainer;
            return this;
        }

        @Override
        @JsonProperty(value="CgroupPermissions")
        public final Builder cgroupPermissions(@Nullable String cgroupPermissions) {
            this.cgroupPermissions = cgroupPermissions;
            return this;
        }

        @Override
        public ImmutableDevice build() {
            return new ImmutableDevice(this.pathOnHost, this.pathInContainer, this.cgroupPermissions);
        }
    }
}

