/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.EndpointVirtualIp;

final class ImmutableEndpointVirtualIp
implements EndpointVirtualIp {
    private final String networkId;
    @Nullable
    private final String addr;

    private ImmutableEndpointVirtualIp(String networkId, @Nullable String addr) {
        this.networkId = networkId;
        this.addr = addr;
    }

    @Override
    @JsonProperty(value="NetworkID")
    public String networkId() {
        return this.networkId;
    }

    @Override
    @JsonProperty(value="Addr")
    @Nullable
    public String addr() {
        return this.addr;
    }

    public final ImmutableEndpointVirtualIp withNetworkId(String value) {
        String newValue = Objects.requireNonNull(value, "networkId");
        if (this.networkId.equals(newValue)) {
            return this;
        }
        return new ImmutableEndpointVirtualIp(newValue, this.addr);
    }

    public final ImmutableEndpointVirtualIp withAddr(@Nullable String value) {
        if (Objects.equals(this.addr, value)) {
            return this;
        }
        return new ImmutableEndpointVirtualIp(this.networkId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEndpointVirtualIp && this.equalTo((ImmutableEndpointVirtualIp)another);
    }

    private boolean equalTo(ImmutableEndpointVirtualIp another) {
        return this.networkId.equals(another.networkId) && Objects.equals(this.addr, another.addr);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.networkId.hashCode();
        h += (h << 5) + Objects.hashCode(this.addr);
        return h;
    }

    public String toString() {
        return "EndpointVirtualIp{networkId=" + this.networkId + ", addr=" + this.addr + "}";
    }

    public static ImmutableEndpointVirtualIp copyOf(EndpointVirtualIp instance) {
        if (instance instanceof ImmutableEndpointVirtualIp) {
            return (ImmutableEndpointVirtualIp)instance;
        }
        return ImmutableEndpointVirtualIp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_NETWORK_ID = 1L;
        private long initBits = 1L;
        private String networkId;
        private String addr;

        private Builder() {
        }

        public final Builder from(EndpointVirtualIp instance) {
            Objects.requireNonNull(instance, "instance");
            this.networkId(instance.networkId());
            String addrValue = instance.addr();
            if (addrValue != null) {
                this.addr(addrValue);
            }
            return this;
        }

        @JsonProperty(value="NetworkID")
        public final Builder networkId(String networkId) {
            this.networkId = Objects.requireNonNull(networkId, "networkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Addr")
        public final Builder addr(@Nullable String addr) {
            this.addr = addr;
            return this;
        }

        public ImmutableEndpointVirtualIp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEndpointVirtualIp(this.networkId, this.addr);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("networkId");
            }
            return "Cannot build EndpointVirtualIp, some of required attributes are not set " + attributes;
        }
    }
}

