/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Driver;
import org.mandas.docker.client.messages.swarm.IpamOptions;
import org.mandas.docker.client.messages.swarm.NetworkSpec;

final class ImmutableNetworkSpec
implements NetworkSpec {
    private final String name;
    @Nullable
    private final Map<String, String> labels;
    private final Driver driverConfiguration;
    @Nullable
    private final Boolean ipv6Enabled;
    @Nullable
    private final Boolean internal;
    @Nullable
    private final Boolean attachable;
    @Nullable
    private final IpamOptions ipamOptions;

    private ImmutableNetworkSpec(String name, @Nullable Map<String, String> labels, Driver driverConfiguration, @Nullable Boolean ipv6Enabled, @Nullable Boolean internal, @Nullable Boolean attachable, @Nullable IpamOptions ipamOptions) {
        this.name = name;
        this.labels = labels;
        this.driverConfiguration = driverConfiguration;
        this.ipv6Enabled = ipv6Enabled;
        this.internal = internal;
        this.attachable = attachable;
        this.ipamOptions = ipamOptions;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="DriverConfiguration")
    public Driver driverConfiguration() {
        return this.driverConfiguration;
    }

    @Override
    @JsonProperty(value="IPv6Enabled")
    @Nullable
    public Boolean ipv6Enabled() {
        return this.ipv6Enabled;
    }

    @Override
    @JsonProperty(value="Internal")
    @Nullable
    public Boolean internal() {
        return this.internal;
    }

    @Override
    @JsonProperty(value="Attachable")
    @Nullable
    public Boolean attachable() {
        return this.attachable;
    }

    @Override
    @JsonProperty(value="IPAMOptions")
    @Nullable
    public IpamOptions ipamOptions() {
        return this.ipamOptions;
    }

    public final ImmutableNetworkSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkSpec(newValue, this.labels, this.driverConfiguration, this.ipv6Enabled, this.internal, this.attachable, this.ipamOptions);
    }

    public final ImmutableNetworkSpec withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableNetworkSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetworkSpec(this.name, newValue, this.driverConfiguration, this.ipv6Enabled, this.internal, this.attachable, this.ipamOptions);
    }

    public final ImmutableNetworkSpec withDriverConfiguration(Driver value) {
        if (this.driverConfiguration == value) {
            return this;
        }
        Driver newValue = Objects.requireNonNull(value, "driverConfiguration");
        return new ImmutableNetworkSpec(this.name, this.labels, newValue, this.ipv6Enabled, this.internal, this.attachable, this.ipamOptions);
    }

    public final ImmutableNetworkSpec withIpv6Enabled(@Nullable Boolean value) {
        if (Objects.equals(this.ipv6Enabled, value)) {
            return this;
        }
        return new ImmutableNetworkSpec(this.name, this.labels, this.driverConfiguration, value, this.internal, this.attachable, this.ipamOptions);
    }

    public final ImmutableNetworkSpec withInternal(@Nullable Boolean value) {
        if (Objects.equals(this.internal, value)) {
            return this;
        }
        return new ImmutableNetworkSpec(this.name, this.labels, this.driverConfiguration, this.ipv6Enabled, value, this.attachable, this.ipamOptions);
    }

    public final ImmutableNetworkSpec withAttachable(@Nullable Boolean value) {
        if (Objects.equals(this.attachable, value)) {
            return this;
        }
        return new ImmutableNetworkSpec(this.name, this.labels, this.driverConfiguration, this.ipv6Enabled, this.internal, value, this.ipamOptions);
    }

    public final ImmutableNetworkSpec withIpamOptions(@Nullable IpamOptions value) {
        if (this.ipamOptions == value) {
            return this;
        }
        return new ImmutableNetworkSpec(this.name, this.labels, this.driverConfiguration, this.ipv6Enabled, this.internal, this.attachable, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkSpec && this.equalTo((ImmutableNetworkSpec)another);
    }

    private boolean equalTo(ImmutableNetworkSpec another) {
        return this.name.equals(another.name) && Objects.equals(this.labels, another.labels) && this.driverConfiguration.equals(another.driverConfiguration) && Objects.equals(this.ipv6Enabled, another.ipv6Enabled) && Objects.equals(this.internal, another.internal) && Objects.equals(this.attachable, another.attachable) && Objects.equals(this.ipamOptions, another.ipamOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + this.driverConfiguration.hashCode();
        h += (h << 5) + Objects.hashCode(this.ipv6Enabled);
        h += (h << 5) + Objects.hashCode(this.internal);
        h += (h << 5) + Objects.hashCode(this.attachable);
        h += (h << 5) + Objects.hashCode(this.ipamOptions);
        return h;
    }

    public String toString() {
        return "NetworkSpec{name=" + this.name + ", labels=" + this.labels + ", driverConfiguration=" + this.driverConfiguration + ", ipv6Enabled=" + this.ipv6Enabled + ", internal=" + this.internal + ", attachable=" + this.attachable + ", ipamOptions=" + this.ipamOptions + "}";
    }

    public static ImmutableNetworkSpec copyOf(NetworkSpec instance) {
        if (instance instanceof ImmutableNetworkSpec) {
            return (ImmutableNetworkSpec)instance;
        }
        return ImmutableNetworkSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DRIVER_CONFIGURATION = 2L;
        private long initBits = 3L;
        private String name;
        private Map<String, String> labels = null;
        private Driver driverConfiguration;
        private Boolean ipv6Enabled;
        private Boolean internal;
        private Boolean attachable;
        private IpamOptions ipamOptions;

        private Builder() {
        }

        public final Builder from(NetworkSpec instance) {
            IpamOptions ipamOptionsValue;
            Boolean attachableValue;
            Boolean internalValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            Map<String, String> labelsValue = instance.labels();
            if (labelsValue != null) {
                this.putAllLabels(labelsValue);
            }
            this.driverConfiguration(instance.driverConfiguration());
            Boolean ipv6EnabledValue = instance.ipv6Enabled();
            if (ipv6EnabledValue != null) {
                this.ipv6Enabled(ipv6EnabledValue);
            }
            if ((internalValue = instance.internal()) != null) {
                this.internal(internalValue);
            }
            if ((attachableValue = instance.attachable()) != null) {
                this.attachable(attachableValue);
            }
            if ((ipamOptionsValue = instance.ipamOptions()) != null) {
                this.ipamOptions(ipamOptionsValue);
            }
            return this;
        }

        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, "labels value"));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, "labels value"));
            return this;
        }

        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, "labels value"));
            }
            return this;
        }

        @JsonProperty(value="DriverConfiguration")
        public final Builder driverConfiguration(Driver driverConfiguration) {
            this.driverConfiguration = Objects.requireNonNull(driverConfiguration, "driverConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="IPv6Enabled")
        public final Builder ipv6Enabled(@Nullable Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        @JsonProperty(value="Internal")
        public final Builder internal(@Nullable Boolean internal) {
            this.internal = internal;
            return this;
        }

        @JsonProperty(value="Attachable")
        public final Builder attachable(@Nullable Boolean attachable) {
            this.attachable = attachable;
            return this;
        }

        @JsonProperty(value="IPAMOptions")
        public final Builder ipamOptions(@Nullable IpamOptions ipamOptions) {
            this.ipamOptions = ipamOptions;
            return this;
        }

        public ImmutableNetworkSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkSpec(this.name, this.labels == null ? null : ImmutableNetworkSpec.createUnmodifiableMap(false, false, this.labels), this.driverConfiguration, this.ipv6Enabled, this.internal, this.attachable, this.ipamOptions);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("driverConfiguration");
            }
            return "Cannot build NetworkSpec, some of required attributes are not set " + attributes;
        }
    }
}

