/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.resources.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.resources.ui.WSSearchSwitch;
import org.eclipse.rcptt.ui.search.Matcher;
import org.eclipse.rcptt.workspace.WorkspaceVerification;

public class WorkspaceVerificationMatcher
implements Matcher {
    public boolean matches(IQ7NamedElement object, String query, SubMonitor monitor) {
        if (!(object instanceof IVerification)) {
            return false;
        }
        String type = Q7SearchCore.findVerificationTypeByDocument((IQ7Element)((IVerification)object));
        if (type == null) {
            try {
                type = ((IVerification)object).getType().getId();
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        if (type != null && !type.equals("org.eclipse.rcptt.verification.workspace")) {
            return false;
        }
        try {
            NamedElement verification = object.getNamedElement();
            if (verification instanceof WorkspaceVerification) {
                WorkspaceVerification wsVerification = (WorkspaceVerification)verification;
                WSSearchSwitch sw = new WSSearchSwitch(query, (IProgressMonitor)monitor);
                try {
                    return (Boolean)sw.doSwitch((EObject)wsVerification.getContent());
                }
                catch (OperationCanceledException operationCanceledException) {
                    return false;
                }
            }
            return false;
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return false;
        }
    }
}

