/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.broadcast.BroadcastSupport;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoAllProperties;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateText;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public abstract class ObjectInfo
implements IObjectInfo {
    public static final String KEY_NO_REFRESHED_BROADCAST = "ObjectInfo: don't send refreshed() broadcast";
    private ObjectInfo m_parent;
    private final List<ObjectInfo> m_children = Lists.newLinkedList();
    private BroadcastSupport m_broadcastSupport;
    protected static final String FLAG_DELETING = "we are in process of deleting";
    private int m_editDepth;
    private Map<Object, Object> m_arbitraryMap;

    @Override
    public abstract IObjectPresentation getPresentation();

    @Override
    public ObjectInfo getUnderlyingModel() {
        return this;
    }

    public final boolean isRoot() {
        return this.m_parent == null;
    }

    public final boolean isItOrParentOf(ObjectInfo o) {
        return o == this || this.isParentOf(o);
    }

    public final boolean isParentOf(ObjectInfo o) {
        while (o != null) {
            ObjectInfo parent = o.getParent();
            if (parent != null && !parent.getChildren().contains(o)) {
                return false;
            }
            if (parent == this) {
                return true;
            }
            o = parent;
        }
        return false;
    }

    public final <T extends ObjectInfo> T getParent(List<T> parents) {
        ObjectInfo o = this.getParent();
        while (o != null) {
            if (parents.contains(o)) {
                return (T)o;
            }
            o = o.getParent();
        }
        return null;
    }

    public final ObjectInfo getRoot() {
        return this.m_parent == null ? this : this.m_parent.getRoot();
    }

    @Override
    public final ObjectInfo getParent() {
        return this.m_parent;
    }

    public final void setParent(ObjectInfo parent) {
        this.m_parent = parent;
    }

    public final List<ObjectInfo> getChildren() {
        return this.m_children;
    }

    public final <T extends ObjectInfo> List<T> getChildren(Class<T> clazz) {
        return GenericsUtils.select(this.m_children, clazz);
    }

    public final void addChild(ObjectInfo child) throws Exception {
        this.addChild(child, null);
    }

    public final void addChildFirst(ObjectInfo child) throws Exception {
        ObjectInfo nextChild = GenericsUtils.getFirstOrNull(this.m_children);
        this.addChild(child, nextChild);
    }

    public final void addChild(final ObjectInfo child, ObjectInfo nextChild) throws Exception {
        Assert.isNotNull(child);
        Assert.isTrue(!this.m_children.contains(child));
        child.accept(new ObjectInfoVisitor(){

            @Override
            public void endVisit(ObjectInfo objectInfo) throws Exception {
                Assert.isTrue(objectInfo != ObjectInfo.this, "<code>%s</code> is parent of <code>%s</code>, so first can not be added as child of second.", child, ObjectInfo.this);
            }
        });
        ObjectInfo[] nextChild_ref = new ObjectInfo[]{nextChild};
        this.getBroadcast(ObjectInfoChildAddBefore.class).invoke(this, child, nextChild_ref);
        nextChild = nextChild_ref[0];
        int index = nextChild != null ? this.m_children.indexOf(nextChild) : this.m_children.size();
        this.m_children.add(index, child);
        child.m_parent = this;
        this.getBroadcast(ObjectInfoChildAddAfter.class).invoke(this, child);
    }

    public final void moveChild(ObjectInfo child, ObjectInfo nextChild) throws Exception {
        Assert.isTrue(this.m_children.contains(child));
        if (child != nextChild) {
            this.getBroadcastObject().childMoveBefore(this, child, nextChild);
            int oldIndex = this.m_children.indexOf(child);
            this.m_children.remove(child);
            int index = nextChild != null ? this.m_children.indexOf(nextChild) : this.m_children.size();
            this.m_children.add(index, child);
            this.getBroadcastObject().childMoveAfter(this, child, nextChild, oldIndex, index);
        }
    }

    public final void removeChild(ObjectInfo child) throws Exception {
        Assert.isTrue(this.m_children.contains(child));
        this.getBroadcastObject().childRemoveBefore(this, child);
        this.m_children.remove(child);
        this.getBroadcastObject().childRemoveAfter(this, child);
    }

    public final void replaceChild(ObjectInfo oldChild, ObjectInfo newChild) throws Exception {
        Assert.isTrue(this.m_children.contains(oldChild));
        Assert.isNotNull(newChild);
        int index = this.m_children.indexOf(oldChild);
        this.m_children.set(index, newChild);
        newChild.m_parent = this;
    }

    public final void accept(ObjectInfoVisitor visitor) {
        ExecutionUtils.runRethrow(() -> this.accept0(visitor));
    }

    public final void accept0(ObjectInfoVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            for (ObjectInfo child : this.getChildren()) {
                child.accept0(visitor);
            }
            visitor.endVisit(this);
        }
    }

    public BroadcastSupport getBroadcastSupport() {
        return this.isRoot() ? this.m_broadcastSupport : this.getRoot().getBroadcastSupport();
    }

    public <T> T getBroadcast(Class<T> listenerClass) {
        return this.getBroadcastSupport().getListener(listenerClass);
    }

    @Override
    public final void addBroadcastListener(Object listenerImpl) {
        this.getBroadcastSupport().addListener(this, listenerImpl);
    }

    public final void removeBroadcastListener(Object listenerImpl) {
        this.getBroadcastSupport().removeListener(this, listenerImpl);
    }

    public final void targetBroadcastListener(ObjectInfo newTarget) {
        this.getBroadcastSupport().targetListener(this, newTarget);
    }

    protected final void setBroadcastSupport(BroadcastSupport broadcastSupport) {
        this.m_broadcastSupport = broadcastSupport;
    }

    public final ObjectEventListener getBroadcastObject() {
        return ExecutionUtils.runObject(() -> this.getBroadcastSupport().getListener(ObjectEventListener.class));
    }

    public Property[] getProperties() throws Exception {
        List<Property> propertyList = this.getPropertyList();
        this.getBroadcast(ObjectInfoAllProperties.class).invoke(this, propertyList);
        this.sortPropertyList(propertyList);
        return propertyList.toArray(new Property[propertyList.size()]);
    }

    protected void sortPropertyList(List<Property> properties) {
        Collections.sort(properties, (o1, o2) -> o1.getTitle().compareTo(o2.getTitle()));
    }

    protected List<Property> getPropertyList() throws Exception {
        return Lists.newArrayList();
    }

    @Override
    public final Property getPropertyByTitle(String title) throws Exception {
        for (Property property : this.getPropertyList()) {
            if (!title.equals(property.getTitle())) continue;
            return property;
        }
        return null;
    }

    @Override
    public final boolean isDeleting() {
        return this.getArbitraryValue(FLAG_DELETING) != null;
    }

    public boolean canDelete() {
        return false;
    }

    @Override
    public void delete() throws Exception {
    }

    @Override
    public final boolean isDeleted() {
        return this.m_parent != null && !this.m_parent.m_children.contains(this);
    }

    public final void startEdit() throws Exception {
        ObjectInfo root = this.getRoot();
        ++root.m_editDepth;
    }

    public final void endEdit() throws Exception {
        ObjectInfo root = this.getRoot();
        --root.m_editDepth;
        if (root.m_editDepth == 0) {
            root.fire_aboutToRefresh();
            root.saveEdit();
            root.refresh();
        }
    }

    private void fire_aboutToRefresh() throws Exception {
        ++this.m_editDepth;
        this.getBroadcastObject().endEdit_aboutToRefresh();
        --this.m_editDepth;
    }

    protected void saveEdit() throws Exception {
    }

    public final void refresh() throws Exception {
        Assert.isLegal(this.isRoot());
        this.getBroadcastSupport().cleanUpTargets(this);
        this.execRefreshOperation(() -> ExecutionUtils.runDesignTime(() -> this.refreshCreate0()));
        this.execRefreshOperation(() -> ExecutionUtils.runDesignTime(() -> {
            this.refresh_fetch();
            this.refresh_finish();
        }));
        if (this.getArbitraryValue(KEY_NO_REFRESHED_BROADCAST) != Boolean.FALSE) {
            this.getBroadcastObject().refreshed();
            this.getBroadcastObject().refreshed2();
        }
    }

    protected void execRefreshOperation(RunnableEx runnableEx) throws Exception {
        runnableEx.run();
    }

    public final void refreshLight() throws Exception {
        Assert.isLegal(this.isRoot());
        this.execRefreshOperation(() -> ExecutionUtils.runDesignTime(() -> this.refreshCreate0()));
        this.execRefreshOperation(() -> ExecutionUtils.runDesignTime(() -> this.refresh_finish()));
    }

    private void refreshCreate0() throws Exception {
        this.refresh_dispose();
        try {
            this.refresh_beforeCreate();
            this.refresh_create();
            this.refresh_afterCreate0();
            this.refresh_afterCreate();
            this.refresh_afterCreate2();
        }
        finally {
            this.getBroadcast(ObjectEventListener.class).refreshFinallyRefresh();
        }
    }

    public void refresh_dispose() throws Exception {
        if (this.isRoot()) {
            this.getBroadcastObject().refreshDispose();
        }
        for (ObjectInfo child : this.getChildren()) {
            child.refresh_dispose();
        }
    }

    public void refresh_beforeCreate() throws Exception {
        if (this.isRoot()) {
            this.getBroadcastObject().refreshBeforeCreate();
        }
        for (ObjectInfo child : this.getChildren()) {
            child.refresh_beforeCreate();
        }
    }

    protected void refresh_create() throws Exception {
        for (ObjectInfo child : this.getChildren()) {
            child.refresh_create();
        }
    }

    protected void refresh_afterCreate0() throws Exception {
        if (this.isRoot()) {
            this.getBroadcastObject().refreshAfterCreate0();
        }
        for (ObjectInfo child : this.getChildren()) {
            child.refresh_afterCreate0();
        }
    }

    protected void refresh_afterCreate() throws Exception {
        if (this.isRoot()) {
            this.getBroadcastObject().refreshAfterCreate();
        }
        for (ObjectInfo child : this.getChildren()) {
            child.refresh_afterCreate();
        }
    }

    protected void refresh_afterCreate2() throws Exception {
        if (this.isRoot()) {
            this.getBroadcastObject().refreshAfterCreate2();
        }
        for (ObjectInfo child : this.getChildren()) {
            child.refresh_afterCreate2();
        }
    }

    protected void refresh_fetch() throws Exception {
        for (ObjectInfo child : this.getChildren()) {
            child.refresh_fetch();
        }
    }

    protected void refresh_finish() throws Exception {
        ImmutableList children = this.getChildren();
        children = ImmutableList.copyOf(this.getChildren());
        for (ObjectInfo child : children) {
            child.refresh_finish();
        }
    }

    public final void putArbitraryValue(Object key, Object value) {
        if (this.m_arbitraryMap == null) {
            this.m_arbitraryMap = new HashMap<Object, Object>();
        }
        this.m_arbitraryMap.put(key, value);
    }

    public final Object getArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            return this.m_arbitraryMap.get(key);
        }
        return null;
    }

    public final void removeArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            this.m_arbitraryMap.remove(key);
        }
    }

    public final Map<Object, Object> getArbitraries() {
        Object arbitraries = this.m_arbitraryMap != null ? new HashMap<Object, Object>(this.m_arbitraryMap) : ImmutableMap.of();
        return arbitraries;
    }

    public static ImageDescriptor getImageDescriptor(ObjectInfo objectInfo) {
        return ExecutionUtils.runObjectLog(() -> {
            ImageDescriptor icon = objectInfo.getPresentation().getIcon();
            ImageDescriptor[] decoratedIcon = new ImageDescriptor[]{icon};
            objectInfo.getBroadcast(ObjectInfoPresentationDecorateIcon.class).invoke(objectInfo, decoratedIcon);
            icon = decoratedIcon[0];
            return icon;
        }, null);
    }

    public static String getText(ObjectInfo objectInfo) {
        return ExecutionUtils.runObjectLog(() -> {
            String text = objectInfo.getPresentation().getText();
            String[] decoratedText = new String[]{text};
            objectInfo.getBroadcast(ObjectInfoPresentationDecorateText.class).invoke(objectInfo, decoratedText);
            text = decoratedText[0];
            return text;
        }, "<exception, see log>");
    }
}

