/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt;

import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.wb.draw2d.IColorConstants;

public class VisualDataMockupProvider {
    public static final int MENU_ITEM_SEPARATOR_HEIGHT = 11;

    public Image mockMenuPopupVisualData(Menu menu, int[] bounds) {
        int menuHeight = 4;
        int menuWidth = 5;
        GC gc = new GC((Drawable)menu.getDisplay());
        int i = 0;
        while (i < menu.getItemCount()) {
            int itemHeight;
            int itemWidth = 24;
            MenuItem item = menu.getItem(i);
            if ((item.getStyle() & 2) != 0) {
                itemHeight = 11;
            } else {
                String text;
                Image itemImage = item.getImage();
                int imageHeight = 0;
                int textHeight = 0;
                if (itemImage != null) {
                    Rectangle itemImageBounds = itemImage.getBounds();
                    itemWidth += itemImageBounds.width + 5;
                    imageHeight = itemImageBounds.height;
                }
                if ((text = item.getText()) != null) {
                    Point textDimensions = gc.stringExtent(text);
                    itemWidth += textDimensions.x;
                    textHeight = textDimensions.y;
                }
                itemHeight = 3 + Math.max(imageHeight, textHeight) + 3;
            }
            bounds[i * 4 + 0] = 0;
            bounds[i * 4 + 1] = menuHeight;
            bounds[i * 4 + 3] = itemHeight;
            menuHeight += itemHeight;
            menuWidth = Math.max(itemWidth, menuWidth);
            ++i;
        }
        menuHeight += 4;
        menuWidth += 20;
        i = 0;
        while (i < menu.getItemCount()) {
            bounds[i * 4 + 2] = menuWidth;
            ++i;
        }
        gc.dispose();
        Image image = new Image((Device)menu.getDisplay(), menuWidth, menuHeight);
        gc = new GC((Drawable)image);
        gc.setBackground(IColorConstants.buttonLightest);
        gc.fillRectangle(image.getBounds());
        int i2 = 0;
        while (i2 < menu.getItemCount()) {
            MenuItem item = menu.getItem(i2);
            int x = bounds[i2 * 4 + 0];
            int y = bounds[i2 * 4 + 1] + bounds[i2 * 4 + 3] / 2;
            if ((item.getStyle() & 2) != 0) {
                gc.setForeground(IColorConstants.lightGray);
                gc.drawLine(x, y, x + menuWidth, y);
            } else {
                String text;
                if (item.getEnabled()) {
                    gc.setForeground(IColorConstants.menuForeground);
                } else {
                    gc.setForeground(IColorConstants.gray);
                }
                if (item.getSelection()) {
                    Image checkImage = this.loadImage("check.png");
                    int checkHalfHeight = checkImage.getBounds().height / 2;
                    gc.drawImage(checkImage, x + 3, y - checkHalfHeight);
                    checkImage.dispose();
                }
                x += 20;
                Image itemImage = item.getImage();
                if (itemImage != null) {
                    Rectangle itemImageBounds = itemImage.getBounds();
                    int imageHalfHeight = itemImageBounds.height / 2;
                    gc.drawImage(itemImage, x, y - imageHalfHeight);
                    x += itemImageBounds.width + 5;
                }
                if ((text = item.getText()) != null) {
                    Point textDimensions = gc.stringExtent(text);
                    gc.drawString(text, x, y - textDimensions.y / 2 - 1, true);
                }
                if ((item.getStyle() & 0x40) != 0) {
                    Image cascadeImage = this.loadImage("cascade.png");
                    Rectangle imageBounds = cascadeImage.getBounds();
                    int itemWidth = bounds[i2 * 4 + 2];
                    gc.drawImage(cascadeImage, itemWidth - imageBounds.width, y - imageBounds.height / 2);
                    cascadeImage.dispose();
                }
            }
            ++i2;
        }
        gc.dispose();
        return image;
    }

    private Image loadImage(String image) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream imageStream = this.getClass().getResourceAsStream(image);){
                return new Image(null, imageStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            return new Image(null, 1, 1);
        }
    }
}

