/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenEvent;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.EditRepositoryWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.MultiRepositoryAwareWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewLocalTaskWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.TaskRepositoryWizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class TasksUiUtil {
    @Deprecated
    public static final int FLAG_NO_RICH_EDITOR = 131072;

    public static ITask createOutgoingNewTask(String connectorKind, String repositoryUrl) {
        Assert.isNotNull((Object)connectorKind);
        LocalTask task = TasksUiInternal.createNewLocalTask(null);
        task.setAttribute("outgoingNewConnectorKind", connectorKind);
        task.setAttribute("outgoingNewRepositoryUrl", repositoryUrl);
        task.setSynchronizationState(ITask.SynchronizationState.OUTGOING_NEW);
        return task;
    }

    public static boolean isOutgoingNewTask(ITask task, String connectorKind) {
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)connectorKind);
        return connectorKind.equals(task.getAttribute("outgoingNewConnectorKind"));
    }

    public static TaskRepository getOutgoingNewTaskRepository(ITask task) {
        Assert.isNotNull((Object)task);
        String connectorKind = task.getAttribute("outgoingNewConnectorKind");
        String repositoryUrl = task.getAttribute("outgoingNewRepositoryUrl");
        if (connectorKind != null && repositoryUrl != null) {
            return TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
        }
        return null;
    }

    public static TaskRepository getSelectedRepository() {
        return TasksUiUtil.getSelectedRepository(null);
    }

    /*
     * WARNING - void declaration
     */
    public static TaskRepository getSelectedRepository(StructuredViewer viewer) {
        IWorkbenchWindow window;
        ISelection windowSelection;
        IStructuredSelection selection = null;
        if (viewer != null) {
            selection = (IStructuredSelection)viewer.getSelection();
        }
        if ((selection == null || selection.isEmpty()) && (windowSelection = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getSelectionService().getSelection()) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)windowSelection;
        }
        if (selection == null) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof TaskRepository) {
            return (TaskRepository)selection.getFirstElement();
        }
        Object object = element;
        if (object instanceof IRepositoryQuery) {
            void query;
            windowSelection = (IRepositoryQuery)object;
            IRepositoryQuery cfr_ignored_0 = (IRepositoryQuery)object;
            return TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
        }
        Object object2 = element;
        if (object2 instanceof ITask) {
            void task;
            ITask iTask = (ITask)object2;
            ITask cfr_ignored_1 = (ITask)object2;
            return TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        }
        Object object3 = element;
        if (object3 instanceof IResource) {
            void resource;
            IResource iResource = (IResource)object3;
            IResource cfr_ignored_2 = (IResource)object3;
            return TasksUiPlugin.getDefault().getRepositoryForResource((IResource)resource);
        }
        Object object4 = element;
        if (object4 instanceof IAdaptable) {
            void adaptable;
            IAdaptable iAdaptable = (IAdaptable)object4;
            IAdaptable cfr_ignored_3 = (IAdaptable)object4;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                return TasksUiPlugin.getDefault().getRepositoryForResource(resource);
            }
            ITask task = (ITask)adaptable.getAdapter(AbstractTask.class);
            if (task != null) {
                ITask rtask = task;
                return TasksUi.getRepositoryManager().getRepository(rtask.getConnectorKind(), rtask.getRepositoryUrl());
            }
        }
        return null;
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId, IWorkbenchPage page) {
        IWorkbenchWindow window;
        if (page == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            page = window.getActivePage();
        }
        if (page == null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for \"" + String.valueOf(input) + "\": no active workbench window"));
            return null;
        }
        try {
            return page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Open for editor failed: " + String.valueOf(input) + ", taskId: " + editorId, (Throwable)e), 3);
            return null;
        }
    }

    public static int openEditRepositoryWizard(TaskRepository repository) {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        if (connector == null || !connector.isUserManaged() && !connector.getConnectorKind().equals("local")) {
            return 1;
        }
        EditRepositoryWizard wizard = new EditRepositoryWizard(repository, TasksUiPlugin.getConnectorUi(repository.getConnectorKind()));
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            TaskRepositoryWizardDialog dialog = new TaskRepositoryWizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                return 1;
            }
        }
        if (TaskRepositoriesView.getFromActivePerspective() != null) {
            TaskRepositoriesView.getFromActivePerspective().getViewer().refresh();
        }
        return 0;
    }

    public static boolean openNewLocalTaskEditor(Shell shell, ITaskMapping taskSelection) {
        return TasksUiUtil.openNewTaskEditor(shell, (IWizard)new NewLocalTaskWizard(taskSelection), taskSelection);
    }

    private static boolean openNewTaskEditor(Shell shell, IWizard wizard, ITaskMapping taskSelection) {
        WizardDialog dialog = new WizardDialog(shell, wizard);
        dialog.setHelpAvailable(false);
        dialog.setBlockOnOpen(true);
        dialog.create();
        if (!(wizard instanceof MultiRepositoryAwareWizard) && wizard.canFinish()) {
            wizard.performFinish();
            return true;
        }
        int result = dialog.open();
        return result == 0;
    }

    public static boolean openNewTaskEditor(Shell shell, ITaskMapping taskSelection, TaskRepository taskRepository) {
        MultiRepositoryAwareWizard wizard;
        if (taskRepository != null) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
            wizard = connectorUi.getNewTaskWizard(taskRepository, taskSelection);
        } else {
            wizard = TasksUiInternal.createNewTaskWizard(taskSelection);
        }
        return TasksUiUtil.openNewTaskEditor(shell, (IWizard)wizard, taskSelection);
    }

    @Deprecated
    public static boolean openRepositoryTask(String repositoryUrl, String taskId, String fullUrl) {
        return TasksUiUtil.openTask(repositoryUrl, taskId, fullUrl);
    }

    @Deprecated
    public static boolean openRepositoryTask(TaskRepository repository, String taskId) {
        return TasksUiUtil.openTask(repository, taskId);
    }

    public static boolean openTask(ITask task) {
        return TasksUiInternal.openTask(task, task.getTaskId()) != null;
    }

    public static void openTask(String url) {
        AbstractTask task = TasksUiInternal.getTaskByUrl(url);
        if (task != null && !(task instanceof LocalTask)) {
            TasksUiUtil.openTask((ITask)task);
        } else {
            TaskRepository repository;
            String id;
            String repositoryUrl;
            AbstractRepositoryConnector connector;
            boolean opened = false;
            if (url != null && (connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(url)) != null && (repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url)) != null && (id = connector.getTaskIdFromTaskUrl(url)) != null && (repository = TasksUi.getRepositoryManager().getRepository(connector.getConnectorKind(), repositoryUrl)) != null) {
                opened = TasksUiUtil.openTask(repository, id);
            }
            if (!opened) {
                BrowserUtil.openUrl((String)url, (int)0);
            }
        }
    }

    public static boolean openTask(String repositoryUrl, String taskId, String fullUrl) {
        return TasksUiUtil.openTask(repositoryUrl, taskId, fullUrl, 0L);
    }

    public static boolean openTask(String repositoryUrl, String taskId, String fullUrl, long timestamp) {
        AbstractTask task = TasksUiInternal.getTask(repositoryUrl, taskId, fullUrl);
        if (task != null) {
            return TasksUiUtil.openTask((ITask)task);
        }
        boolean opened = false;
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(fullUrl);
        if (connector != null) {
            if (repositoryUrl != null && taskId != null) {
                opened = TasksUiInternal.openRepositoryTask(connector.getConnectorKind(), repositoryUrl, taskId, null, timestamp);
            } else {
                repositoryUrl = connector.getRepositoryUrlFromTaskUrl(fullUrl);
                taskId = connector.getTaskIdFromTaskUrl(fullUrl);
                if (repositoryUrl != null && taskId != null) {
                    opened = TasksUiInternal.openRepositoryTask(connector.getConnectorKind(), repositoryUrl, taskId, null, timestamp);
                }
            }
        }
        if (!opened) {
            TasksUiUtil.openUrl(fullUrl);
        }
        return true;
    }

    public static boolean openTask(TaskRepository repository, String taskId) {
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)taskId);
        return TasksUiInternal.openTask(repository, taskId, null);
    }

    public static EditorHandle openTaskWithResult(TaskRepository repository, String taskId) {
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)taskId);
        final EditorHandle handle = new EditorHandle();
        boolean opened = TasksUiInternal.openTask(repository, taskId, new TaskOpenListener(){

            @Override
            public void taskOpened(TaskOpenEvent event) {
                handle.setPart((IWorkbenchPart)event.getEditor());
                handle.setItem((Object)event.getTask());
                handle.setStatus(Status.OK_STATUS);
            }
        });
        return opened ? handle : null;
    }

    public static void openUrl(String location) {
        BrowserUtil.openUrl((String)location, (int)131072);
    }

    public static boolean openWithBrowser(IRepositoryElement element) {
        TaskRepository repository = TasksUiInternal.getRepository(element);
        return repository != null ? TasksUiUtil.openWithBrowser(repository, element) : false;
    }

    public static boolean openWithBrowser(TaskRepository repository, IRepositoryElement element) {
        String url = TasksUiInternal.getAuthenticatedUrl(repository, element);
        if (url != null) {
            TasksUiUtil.openUrl(url);
            return true;
        }
        return false;
    }

    public static IViewPart openTasksViewInActivePerspective() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.mylyn.tasks.ui.views.tasks");
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not show Task List view", (Throwable)e));
            return null;
        }
    }

    public static boolean getHighlightCurrentLine() {
        return TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight");
    }
}

