/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.aql.business.api;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;

public final class TypesUtil {
    private TypesUtil() {
    }

    public static Map<String, Set<IType>> createAQLVariableTypesFromInterpreterContext(IInterpreterContext context, IQueryEnvironment queryEnvironment) {
        LinkedHashMap<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();
        LinkedHashSet<Object> selfTyping = new LinkedHashSet<Object>(2);
        VariableType targetTypeName = context.getTargetType();
        for (TypeName typeName : targetTypeName.getPossibleTypes()) {
            selfTyping.addAll(TypesUtil.searchEClassifierType(queryEnvironment, typeName));
        }
        if (selfTyping.size() == 0) {
            selfTyping.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        }
        variableTypes.put("self", selfTyping);
        for (Map.Entry entry : context.getVariables().entrySet()) {
            VariableType typeName = (VariableType)entry.getValue();
            LinkedHashSet<Object> potentialTypes = new LinkedHashSet<Object>(2);
            for (TypeName possibleVariableTypes : typeName.getPossibleTypes()) {
                if (possibleVariableTypes.getJavaClass().isPresent()) {
                    potentialTypes.add(new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, (Class)possibleVariableTypes.getJavaClass().get()));
                    continue;
                }
                potentialTypes.addAll(TypesUtil.searchEClassifierType(queryEnvironment, possibleVariableTypes));
            }
            if (potentialTypes.size() == 0) {
                potentialTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
            }
            variableTypes.put((String)entry.getKey(), potentialTypes);
        }
        return variableTypes;
    }

    private static Collection<IType> searchEClassifierType(IQueryEnvironment queryEnvironment, TypeName targetTypeName) {
        LinkedHashSet<IType> types = new LinkedHashSet<IType>();
        if (targetTypeName.getJavaClass().isPresent()) {
            types.add((IType)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, (Class)targetTypeName.getJavaClass().get()));
        } else {
            LinkedHashSet found = new LinkedHashSet();
            if (targetTypeName.getPackagePrefix().isPresent()) {
                String typeName = targetTypeName.getClassifierName();
                String name = (String)targetTypeName.getPackagePrefix().get();
                found.addAll(queryEnvironment.getEPackageProvider().getTypes(name, typeName));
            } else {
                found.addAll(queryEnvironment.getEPackageProvider().getTypes(targetTypeName.getClassifierName()));
            }
            for (EClassifier eClassifier : found) {
                types.add((IType)new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, eClassifier));
            }
        }
        return types;
    }
}

