/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.tracing;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;

public class TraceHandler {
    private final String identifier;
    private Tracer tracer = null;

    public TraceHandler(String identifier) {
        this.identifier = identifier != null ? identifier : CoreBundleActivator.getUniqueIdentifier();
        Assert.isNotNull((Object)this.identifier);
    }

    protected final String getIdentifier() {
        return this.identifier;
    }

    protected Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = new Tracer(this.identifier);
        }
        return this.tracer;
    }

    public final int getDebugMode() {
        return this.getTracer().getDebugMode();
    }

    public final boolean isSlotEnabled(String slotId) {
        return this.isSlotEnabled(0, slotId);
    }

    public final boolean isSlotEnabled(int debugMode, String slotId) {
        return this.getTracer().isEnabled(debugMode, slotId);
    }

    public final void trace(String message, Object clazz) {
        this.getTracer().trace(message, 0, null, 1, clazz);
    }

    public final void trace(String message, int debugMode, Object clazz) {
        this.getTracer().trace(message, debugMode, null, 1, clazz);
    }

    public final void trace(String message, String slotId, Object clazz) {
        this.getTracer().trace(message, 0, slotId, 1, clazz);
    }

    public final void trace(String message, int debugMode, String slotId, int severity, Object clazz) {
        this.getTracer().trace(message, debugMode, slotId, severity, clazz);
    }

    protected static class Tracer {
        private final String fIdentifier;
        private final String fDebugModeQualifier;

        public Tracer(String identifier) {
            Assert.isNotNull((Object)identifier);
            this.fIdentifier = identifier;
            this.fDebugModeQualifier = String.valueOf(this.fIdentifier) + "/debugmode";
        }

        protected int getDebugMode() {
            try {
                String mode = Platform.getDebugOption((String)this.fDebugModeQualifier);
                if (mode != null && Integer.decode(mode) > 0) {
                    return Integer.decode(mode);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return 0;
        }

        protected boolean isSlotEnabled(String slotId) {
            return this.fIdentifier != null ? Boolean.parseBoolean(Platform.getDebugOption((String)(String.valueOf(this.fIdentifier) + "/" + slotId))) : false;
        }

        protected final boolean isEnabled(int debugMode, String slotId) {
            return this.getDebugMode() < 0 || debugMode <= this.getDebugMode() && (slotId == null || slotId.trim().length() == 0 || this.isSlotEnabled(slotId));
        }

        protected String getFormattedDebugMessage(String message, int debugMode, String slotId, int severity, Object clazz) {
            StringBuffer debug = new StringBuffer();
            if (slotId != null || clazz != null) {
                if (clazz != null) {
                    String name;
                    String string = name = clazz instanceof Class ? ((Class)clazz).getSimpleName() : clazz.getClass().getSimpleName();
                    debug.append(name.trim().length() > 0 ? name.trim() : (clazz instanceof Class ? ((Class)clazz).getName() : clazz.getClass().getName()));
                }
                if (slotId != null) {
                    debug.append(" at ");
                    debug.append(slotId);
                }
                if (debugMode >= 0) {
                    debug.append(" (Mode ");
                    debug.append(debugMode);
                    debug.append(')');
                }
                debug.append('\n');
                debug.append('\t');
            }
            debug.append(message);
            return debug.toString();
        }

        protected void write(String message, int debugMode, String slotId, int severity, Object clazz) {
            String formattedMessage = this.getFormattedDebugMessage(message, debugMode, slotId, severity, clazz);
            if (severity == 4 || severity == 2) {
                System.err.println(formattedMessage);
            } else {
                System.out.println(formattedMessage);
            }
        }

        public final void trace(String message, int debugMode, String slotId, int severity, Object clazz) {
            if (this.isEnabled(debugMode, slotId)) {
                this.write(message, debugMode, slotId, severity, clazz);
            }
        }
    }
}

