/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.generic.AbstractPopupFigure;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplClassic;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class AnchorFiguresClassic<C extends IControlInfo> {
    private List<Figure> m_alignmentFigures;
    private final SelectionEditPolicy m_policy;
    private final FormLayoutInfoImplClassic<C> m_layoutImpl;

    public AnchorFiguresClassic(SelectionEditPolicy policy, FormLayoutInfoImplClassic<C> impl) {
        this.m_policy = policy;
        this.m_layoutImpl = impl;
    }

    public final void show() {
        if (this.m_alignmentFigures == null) {
            this.m_alignmentFigures = new ArrayList<Figure>();
            List editParts = this.m_policy.getHost().getParent().getChildren();
            for (EditPart editPart : editParts) {
                this.showAlignmentFigures(editPart);
            }
        }
    }

    public final void hide() {
        if (this.m_alignmentFigures != null) {
            for (Figure figure : this.m_alignmentFigures) {
                figure.getParent().remove((IFigure)figure);
            }
            this.m_alignmentFigures = null;
        }
    }

    private Figure createAlignmentFigure(C widget, int side) {
        IEditPartViewer viewer = this.m_policy.getHost().getViewer();
        return PlacementUtils.isHorizontalSide((int)side) ? new HorizontalPopupFigure(this, viewer, widget, side) : new VerticalPopupFigure(this, viewer, widget, side);
    }

    private void showAlignmentFigures(EditPart editPart) {
        Object model = editPart.getModel();
        if (!(model instanceof IControlInfo)) {
            return;
        }
        IControlInfo widget = (IControlInfo)model;
        String showFiguresString = null;
        if (!LayoutPolicyUtils.shouldShowSideFigures(showFiguresString, (EditPart)editPart)) {
            return;
        }
        Figure figure = this.createAlignmentFigure(widget, 1);
        if (figure != null) {
            this.addAlignmentFigure(widget, figure, true, true);
        }
        if ((figure = this.createAlignmentFigure(widget, 4)) != null) {
            this.addAlignmentFigure(widget, figure, false, true);
        }
        if ((figure = this.createAlignmentFigure(widget, 8)) != null) {
            this.addAlignmentFigure(widget, figure, true, false);
        }
        if ((figure = this.createAlignmentFigure(widget, 32)) != null) {
            this.addAlignmentFigure(widget, figure, false, false);
        }
    }

    private void addAlignmentFigure(C component, Figure figure, boolean isLeading, boolean isHorisontal) {
        Layer layer = this.m_policy.getHost().getViewer().getLayer("Clickable Layer");
        Rectangle widgetRect = component.getModelBounds().getCopy();
        PolicyUtils.translateModelToFeedback((SelectionEditPolicy)this.m_policy, (Translatable)widgetRect);
        Dimension figureSize = figure.getSize();
        Point figureLocation = new Point();
        if (isHorisontal) {
            if (isLeading) {
                figureLocation.x = widgetRect.x - figureSize.width - 3;
                figureLocation.y = widgetRect.y + widgetRect.height / 2 - figureSize.height / 2;
            } else {
                figureLocation.x = widgetRect.right() + 3;
                figureLocation.y = widgetRect.y + widgetRect.height / 2 - figureSize.height / 2;
            }
        } else if (isLeading) {
            figureLocation.x = widgetRect.x + widgetRect.width / 2 - figureSize.width / 2;
            figureLocation.y = widgetRect.y - figureSize.height - 3;
        } else {
            figureLocation.x = widgetRect.x + widgetRect.width / 2 - figureSize.width / 2;
            figureLocation.y = widgetRect.bottom() + 3;
        }
        if (widgetRect.width < figureSize.width + 6 || widgetRect.height < figureSize.height + 4) {
            return;
        }
        layer.add((IFigure)figure);
        figure.setLocation(figureLocation);
        this.m_alignmentFigures.add(figure);
    }

    private final class HorizontalPopupFigure
    extends AbstractPopupFigure {
        private final C m_widget;
        private final int m_side;
        final /* synthetic */ AnchorFiguresClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        protected HorizontalPopupFigure(IEditPartViewer viewer, C widget, int side) {
            this.this$0 = (AnchorFiguresClassic)n;
            super(viewer, 9, 5);
            this.m_widget = widget;
            this.m_side = side;
        }

        protected ImageDescriptor getImageDescriptor() {
            return this.this$0.m_layoutImpl.getAnchorActions().getImageHorizontal(this.m_widget, this.m_side);
        }

        protected void fillMenu(IMenuManager manager) {
            this.this$0.m_layoutImpl.getAnchorActions().fillMenuHorizontal(this.m_widget, this.m_side, manager);
        }
    }

    private final class VerticalPopupFigure
    extends AbstractPopupFigure {
        private final C m_widget;
        private final int m_side;
        final /* synthetic */ AnchorFiguresClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        protected VerticalPopupFigure(IEditPartViewer viewer, C widget, int side) {
            this.this$0 = (AnchorFiguresClassic)n;
            super(viewer, 5, 9);
            this.m_widget = widget;
            this.m_side = side;
        }

        protected ImageDescriptor getImageDescriptor() {
            try {
                return this.this$0.m_layoutImpl.getAnchorActions().getImageVertical(this.m_widget, this.m_side);
            }
            catch (Throwable e) {
                throw new Error(e);
            }
        }

        protected void fillMenu(IMenuManager manager) {
            this.this$0.m_layoutImpl.getAnchorActions().fillMenuVertical(this.m_widget, this.m_side, manager);
        }
    }
}

