/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.patterns;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.examples.filesystem.ui.FilesystemPredefinedColoredAreas;
import org.eclipse.graphiti.examples.mm.filesystem.Filesystem;
import org.eclipse.graphiti.examples.mm.filesystem.FilesystemFactory;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.AbstractPattern;
import org.eclipse.graphiti.pattern.IPattern;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public class FilesystemPattern
extends AbstractPattern
implements IPattern {
    public FilesystemPattern() {
        super(null);
    }

    public String getCreateName() {
        return "Filesystem";
    }

    public boolean isMainBusinessObjectApplicable(Object mainBusinessObject) {
        return mainBusinessObject instanceof Filesystem;
    }

    protected boolean isPatternControlled(PictogramElement pictogramElement) {
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        return this.isMainBusinessObjectApplicable(domainObject);
    }

    protected boolean isPatternRoot(PictogramElement pictogramElement) {
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        return this.isMainBusinessObjectApplicable(domainObject);
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        Filesystem newFilesystem = FilesystemFactory.eINSTANCE.createFilesystem();
        newFilesystem.setName(this.createNewName());
        this.getDiagram().eResource().getContents().add((Object)newFilesystem);
        this.addGraphicalRepresentation((IAreaContext)context, newFilesystem);
        return new Object[]{newFilesystem};
    }

    public boolean canAdd(IAddContext context) {
        return context.getNewObject() instanceof Filesystem && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        Filesystem addedDomainObject = (Filesystem)context.getNewObject();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaService gaService = Graphiti.getGaService();
        ContainerShape outerContainerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        Rectangle outerRectangle = gaService.createInvisibleRectangle((PictogramElement)outerContainerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)outerRectangle, context.getX(), context.getY(), context.getWidth(), context.getHeight());
        Rectangle registerRectangle = gaService.createRectangle((GraphicsAlgorithmContainer)outerRectangle);
        gaService.setLocationAndSize((GraphicsAlgorithm)registerRectangle, 0, 0, 20, 20);
        registerRectangle.setFilled(Boolean.valueOf(true));
        gaService.setRenderingStyle((AbstractStyle)registerRectangle, FilesystemPredefinedColoredAreas.getLightGrayAdaptions());
        Rectangle mainRectangle = gaService.createRectangle((GraphicsAlgorithmContainer)outerRectangle);
        this.setLocationAndSizeOfMainContentsArea(outerRectangle, mainRectangle);
        mainRectangle.setFilled(Boolean.valueOf(true));
        gaService.setRenderingStyle((AbstractStyle)mainRectangle, FilesystemPredefinedColoredAreas.getLightGrayAdaptions());
        Shape shape = peCreateService.createShape(outerContainerShape, false);
        Text text = gaService.createText((GraphicsAlgorithmContainer)shape, addedDomainObject.getName());
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        this.setLocationAndSizeOfTextArea(outerRectangle, text);
        peCreateService.createChopboxAnchor((AnchorContainer)outerContainerShape);
        this.link((PictogramElement)outerContainerShape, addedDomainObject);
        return outerContainerShape;
    }

    public boolean canLayout(ILayoutContext context) {
        return context.getPictogramElement() instanceof ContainerShape && this.getBusinessObjectForPictogramElement(context.getPictogramElement()) instanceof Filesystem;
    }

    public boolean layout(ILayoutContext context) {
        GraphicsAlgorithm graphicsAlgorithm;
        Rectangle outerRectangle;
        EList graphicsAlgorithmChildren;
        ContainerShape outerContainerShape;
        GraphicsAlgorithm outerGraphicsAlgorithm;
        boolean changesDone = false;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof ContainerShape && (outerGraphicsAlgorithm = (outerContainerShape = (ContainerShape)pictogramElement).getGraphicsAlgorithm()) instanceof Rectangle && (graphicsAlgorithmChildren = (outerRectangle = (Rectangle)outerGraphicsAlgorithm).getGraphicsAlgorithmChildren()).size() > 1 && (graphicsAlgorithm = (GraphicsAlgorithm)graphicsAlgorithmChildren.get(1)) instanceof Rectangle) {
            this.setLocationAndSizeOfMainContentsArea(outerRectangle, (Rectangle)graphicsAlgorithm);
            changesDone = true;
        }
        Rectangle outerRectangle2 = this.getOuterRectangle(pictogramElement);
        Text nameText = this.getNameText(pictogramElement);
        if (outerRectangle2 != null && nameText != null) {
            this.setLocationAndSizeOfTextArea(outerRectangle2, nameText);
            changesDone = true;
        }
        return changesDone;
    }

    public IReason updateNeeded(IUpdateContext context) {
        Text nameText = this.getNameText(context.getPictogramElement());
        Filesystem domainObject = (Filesystem)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (domainObject.getName() == null || !domainObject.getName().equals(nameText.getValue())) {
            return Reason.createTrueReason((String)("Name differs. Expected: '" + domainObject.getName() + "'"));
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        Text nameText = this.getNameText(context.getPictogramElement());
        Filesystem domainObject = (Filesystem)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        nameText.setValue(domainObject.getName());
        return true;
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        Object domainObject = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        return domainObject instanceof Filesystem && ga instanceof Text;
    }

    public String getInitialValue(IDirectEditingContext context) {
        Filesystem filesystem = (Filesystem)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return filesystem.getName();
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        if (value == null || value.length() == 0) {
            return "Folder name must not be empty";
        }
        Filesystem filesystem = (Filesystem)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        EList children = this.getDiagram().getChildren();
        for (Shape child : children) {
            Object domainObject = this.getBusinessObjectForPictogramElement((PictogramElement)child);
            if (!(domainObject instanceof Filesystem) || domainObject.equals(filesystem) || !value.equals(((Filesystem)domainObject).getName())) continue;
            return "A filesystem with name '" + ((Filesystem)domainObject).getName() + "' already exists.";
        }
        return null;
    }

    public void setValue(String value, IDirectEditingContext context) {
        Filesystem filesystem = (Filesystem)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        filesystem.setName(value);
        this.updatePictogramElement(context.getPictogramElement());
    }

    private void setLocationAndSizeOfMainContentsArea(Rectangle outerRectangle, Rectangle mainRectangle) {
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)mainRectangle, 0, 10, outerRectangle.getWidth(), outerRectangle.getHeight() - 10);
    }

    private void setLocationAndSizeOfTextArea(Rectangle outerRectangle, Text text) {
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)text, 0, 10, outerRectangle.getWidth(), outerRectangle.getHeight() - 10);
    }

    private Rectangle getOuterRectangle(PictogramElement pictogramElement) {
        ContainerShape outerContainerShape;
        GraphicsAlgorithm outerGraphicsAlgorithm;
        if (pictogramElement instanceof ContainerShape && (outerGraphicsAlgorithm = (outerContainerShape = (ContainerShape)pictogramElement).getGraphicsAlgorithm()) instanceof Rectangle) {
            return (Rectangle)outerGraphicsAlgorithm;
        }
        return null;
    }

    private Text getNameText(PictogramElement pictogramElement) {
        Shape shape;
        GraphicsAlgorithm graphicsAlgorithm;
        EList children;
        ContainerShape outerContainerShape;
        GraphicsAlgorithm outerGraphicsAlgorithm;
        if (pictogramElement instanceof ContainerShape && (outerGraphicsAlgorithm = (outerContainerShape = (ContainerShape)pictogramElement).getGraphicsAlgorithm()) instanceof Rectangle && (children = outerContainerShape.getChildren()).size() > 0 && (graphicsAlgorithm = (shape = (Shape)children.get(0)).getGraphicsAlgorithm()) instanceof Text) {
            return (Text)graphicsAlgorithm;
        }
        return null;
    }

    private String createNewName() {
        String initialName = "NewFilesystem";
        Object name = initialName;
        int number = 0;
        while (this.findFilesystem((String)name) != null) {
            name = initialName + ++number;
        }
        return name;
    }

    private Filesystem findFilesystem(String name) {
        EList contents = this.getDiagram().eResource().getContents();
        for (EObject eObject : contents) {
            if (!(eObject instanceof Filesystem) || !name.equals(((Filesystem)eObject).getName())) continue;
            return (Filesystem)eObject;
        }
        return null;
    }
}

