/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;

public final class GenericTypeContainer
implements IGenericType {
    private final Class<?> m_rawType;
    private final int m_dimension;
    private String m_fullName;
    private final String m_simpleName;
    private final List<IGenericType> m_subTypes = new ArrayList<IGenericType>();

    public GenericTypeContainer(Class<?> rawType) {
        this(rawType, 0);
    }

    public GenericTypeContainer(Class<?> rawType, int dimension) {
        this.m_rawType = rawType;
        this.m_dimension = dimension;
        this.m_simpleName = this.m_rawType.getSimpleName();
    }

    @Override
    public Class<?> getRawType() {
        return this.m_rawType;
    }

    @Override
    public String getFullTypeName() {
        if (this.m_fullName == null) {
            int i;
            StringBuffer fullName = new StringBuffer();
            if (this.m_rawType.isArray()) {
                Class<?> type = this.m_rawType;
                i = 0;
                while (i < this.m_dimension) {
                    type = type.getComponentType();
                    ++i;
                }
                fullName.append(CoreUtils.getClassName(type));
            } else {
                fullName.append(CoreUtils.getClassName(this.m_rawType));
            }
            fullName.append("<");
            int count = this.m_subTypes.size();
            i = 0;
            while (i < count) {
                if (i > 0) {
                    fullName.append(", ");
                }
                fullName.append(this.m_subTypes.get(i).getFullTypeName());
                ++i;
            }
            fullName.append(">");
            i = 0;
            while (i < this.m_dimension) {
                fullName.append("[]");
                ++i;
            }
            this.m_fullName = fullName.toString();
        }
        return this.m_fullName;
    }

    @Override
    public String getSimpleTypeName() {
        return this.m_simpleName;
    }

    @Override
    public List<IGenericType> getSubTypes() {
        return this.m_subTypes;
    }

    @Override
    public IGenericType getSubType(int index) {
        if (index >= this.m_subTypes.size()) {
            return ClassGenericType.OBJECT_CLASS;
        }
        return this.m_subTypes.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.m_subTypes.isEmpty();
    }
}

