/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ImmutableTask;
import org.mandas.docker.client.messages.swarm.NetworkAttachment;
import org.mandas.docker.client.messages.swarm.TaskSpec;
import org.mandas.docker.client.messages.swarm.TaskStatus;
import org.mandas.docker.client.messages.swarm.Version;

@JsonDeserialize(builder=ImmutableTask.Builder.class)
@Value.Immutable
@Value.Enclosing
public interface Task {
    @JsonProperty(value="ID")
    public String id();

    @JsonProperty(value="Version")
    public Version version();

    @JsonProperty(value="CreatedAt")
    public Date createdAt();

    @JsonProperty(value="UpdatedAt")
    public Date updatedAt();

    @JsonProperty(value="Name")
    @Nullable
    public String name();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    @JsonProperty(value="Spec")
    public TaskSpec spec();

    @JsonProperty(value="ServiceID")
    public String serviceId();

    @JsonProperty(value="Slot")
    @Nullable
    public Integer slot();

    @JsonProperty(value="NodeID")
    @Nullable
    public String nodeId();

    @JsonProperty(value="Status")
    public TaskStatus status();

    @JsonProperty(value="DesiredState")
    public String desiredState();

    @JsonProperty(value="NetworksAttachments")
    @Nullable
    public List<NetworkAttachment> networkAttachments();

    @JsonProperty(value="JobIteration")
    @Nullable
    public Version jobIteration();

    public static Criteria.Builder find() {
        return ImmutableTask.Criteria.builder();
    }

    @JsonDeserialize(builder=ImmutableTask.Criteria.Builder.class)
    @Value.Immutable
    public static interface Criteria {
        @Nullable
        public String taskId();

        @Nullable
        public String taskName();

        @Nullable
        public String serviceName();

        @Nullable
        public String nodeId();

        @Nullable
        public String label();

        @Nullable
        public String desiredState();

        public static Builder builder() {
            return ImmutableTask.Criteria.builder();
        }

        public static interface Builder {
            public Builder taskId(String var1);

            public Builder taskName(String var1);

            public Builder serviceName(String var1);

            public Builder nodeId(String var1);

            public Builder label(String var1);

            public Builder desiredState(String var1);

            public Criteria build();
        }
    }
}

