/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.WorkbenchStyledLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class RevertFailureDialog
extends MessageDialog {
    private final Map<String, ResolveMerger.MergeFailureReason> reasons;

    public static void show(Shell shell, RevCommit commit, MergeResult result) {
        Map reasons = result != null ? result.getFailingPaths() : null;
        String message = reasons != null && !reasons.isEmpty() ? MessageFormat.format(UIText.RevertFailureDialog_Message, Utils.getShortObjectId((ObjectId)commit)) : MessageFormat.format(UIText.RevertFailureDialog_MessageNoFiles, Utils.getShortObjectId((ObjectId)commit));
        RevertFailureDialog dialog = new RevertFailureDialog(shell, message, reasons);
        dialog.setShellStyle(dialog.getShellStyle() | 0x10000000 | 0x10);
        dialog.open();
    }

    public RevertFailureDialog(Shell shell, String message, Map<String, ResolveMerger.MergeFailureReason> reasons) {
        super(shell, UIText.RevertFailureDialog_Title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.reasons = reasons;
    }

    protected Control createCustomArea(Composite parent) {
        if (this.reasons == null || this.reasons.isEmpty()) {
            return null;
        }
        Composite fileArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 80).applyTo((Control)fileArea);
        GridLayoutFactory.fillDefaults().applyTo(fileArea);
        TreeViewer viewer = new TreeViewer(fileArea);
        viewer.setAutoExpandLevel(-1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                return ((Collection)element).toArray();
            }
        });
        WorkbenchStyledLabelProvider styleProvider = new WorkbenchStyledLabelProvider(){

            @Override
            public StyledString getStyledText(Object element) {
                if (element instanceof RevertFailure) {
                    return ((RevertFailure)((Object)element)).getStyledText(element);
                }
                if (element instanceof Path) {
                    return ((Path)((Object)element)).getStyledText(element);
                }
                return super.getStyledText(element);
            }
        };
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)styleProvider));
        viewer.setComparator(new ViewerComparator());
        HashMap<ResolveMerger.MergeFailureReason, RevertFailure> failures = new HashMap<ResolveMerger.MergeFailureReason, RevertFailure>();
        for (Map.Entry<String, ResolveMerger.MergeFailureReason> reason : this.reasons.entrySet()) {
            RevertFailure failure = (RevertFailure)((Object)failures.get(reason.getValue()));
            if (failure == null) {
                failure = new RevertFailure(reason.getValue());
                failures.put(reason.getValue(), failure);
            }
            failure.add(reason.getKey());
        }
        viewer.setInput(failures.values());
        return fileArea;
    }

    private static class Path
    extends WorkbenchAdapter {
        private final String path;

        private Path(String path) {
            this.path = path;
        }

        public String getLabel(Object object) {
            return this.path;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            String name = new org.eclipse.core.runtime.Path(this.path).lastSegment();
            if (name != null) {
                return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
            }
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        }

        public StyledString getStyledText(Object object) {
            int lastSlash = this.path.lastIndexOf(47);
            StyledString styled = new StyledString();
            if (lastSlash != -1 && lastSlash + 1 < this.path.length()) {
                String name = this.path.substring(lastSlash + 1);
                styled.append(name).append(' ');
                styled.append("- ", StyledString.QUALIFIER_STYLER);
                styled.append(this.path.substring(0, lastSlash), StyledString.QUALIFIER_STYLER);
            } else {
                styled.append(this.path);
            }
            return styled;
        }
    }

    private static class RevertFailure
    extends WorkbenchAdapter {
        private final ResolveMerger.MergeFailureReason reason;
        private final List<Path> paths;

        private RevertFailure(ResolveMerger.MergeFailureReason reason) {
            this.reason = reason;
            this.paths = new ArrayList<Path>();
        }

        private RevertFailure add(String path) {
            this.paths.add(new Path(path));
            return this;
        }

        public Object[] getChildren(Object object) {
            return this.paths.toArray();
        }

        public String getLabel(Object object) {
            switch (this.reason) {
                case DIRTY_INDEX: {
                    return UIText.RevertFailureDialog_ReasonChangesInIndex;
                }
                case DIRTY_WORKTREE: {
                    return UIText.RevertFailureDialog_ReasonChangesInWorkingDirectory;
                }
                case COULD_NOT_DELETE: {
                    return UIText.RevertFailureDialog_ReasonDeleteFailure;
                }
            }
            return super.getLabel(object);
        }

        public StyledString getStyledText(Object object) {
            StyledString styled = new StyledString(this.getLabel(object));
            styled.append(' ');
            styled.append(MessageFormat.format("({0})", this.paths.size()), StyledString.COUNTER_STYLER);
            return styled;
        }
    }
}

