/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PHPExecutableChangeListener
implements Preferences.IPropertyChangeListener {
    private final String bundleId;
    private final String executableKey;

    public PHPExecutableChangeListener(String bundleID, String executableKey) {
        this.bundleId = bundleID;
        this.executableKey = executableKey;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!"org.eclipse.php.debug.coreinstalledPHPDefaults".equals(event.getProperty())) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(this.bundleId);
        String executable = preferences.get(this.executableKey, null);
        if (executable != null && executable.length() > 0) {
            return;
        }
        try {
            PHPexeItem[] exes = PHPexes.getInstance().getAllItems();
            if (exes.length == 1) {
                Logger.debug("PHP executable changed, setting store value for " + this.bundleId + " to " + this.executableKey + " (" + exes[0].getExecutable().toString() + ")");
                preferences.put(this.executableKey, exes[0].getExecutable().toString());
                preferences.flush();
                PHPDebugPlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

