/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters;

import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;

public class SystemFilterUIHelpers {
    static /* synthetic */ Class class$0;

    public static SystemSimpleContentElement getDataElement(SystemSimpleContentElement root, Object data) {
        int idx;
        SystemSimpleContentElement[] children = root.getChildren();
        SystemSimpleContentElement match = null;
        if (children != null && children.length > 0) {
            idx = 0;
            while (match == null && idx < children.length) {
                if (children[idx].getData() == data) {
                    match = children[idx];
                }
                ++idx;
            }
        }
        if (match == null && children != null && children.length > 0) {
            idx = 0;
            while (match == null && idx < children.length) {
                match = SystemFilterUIHelpers.getDataElement(children[idx], data);
                ++idx;
            }
        }
        return match;
    }

    public static SystemSimpleContentElement getFilterPoolModel(ISystemFilterPoolManagerProvider mgrProvider, ISystemFilterPoolManager[] mgrs) {
        SystemSimpleContentElement veryRootElement = new SystemSimpleContentElement("Filter pools", (Object)null, null, null);
        veryRootElement.setRenamable(false);
        veryRootElement.setDeletable(false);
        if (mgrs == null) {
            return veryRootElement;
        }
        Vector<SystemSimpleContentElement> veryRootChildren = new Vector<SystemSimpleContentElement>();
        int idx = 0;
        while (idx < mgrs.length) {
            SystemSimpleContentElement rootElement = new SystemSimpleContentElement(mgrs[idx].getName(), (Object)mgrs[idx], veryRootElement, null);
            rootElement.setRenamable(false);
            rootElement.setDeletable(false);
            rootElement.setImageDescriptor(SystemFilterUIHelpers.getFilterPoolManagerImage(mgrProvider, mgrs[idx]));
            Vector elements = new Vector();
            ISystemFilterPool[] pools = mgrs[idx].getSystemFilterPools();
            SystemFilterUIHelpers.populateFilterPoolContentElementVector(pools, elements, rootElement);
            rootElement.setChildren(elements);
            veryRootChildren.addElement(rootElement);
            ++idx;
        }
        veryRootElement.setChildren(veryRootChildren);
        return veryRootElement;
    }

    protected static void populateFilterPoolContentElementVector(ISystemFilterPool[] pools, Vector elements, SystemSimpleContentElement parentElement) {
        int idx = 0;
        while (idx < pools.length) {
            ISystemFilterPool pool = pools[idx];
            SystemSimpleContentElement cElement = new SystemSimpleContentElement(pool.getName(), (Object)pool, parentElement, null);
            cElement.setImageDescriptor(SystemFilterUIHelpers.getFilterPoolImage(pool.getProvider(), pool));
            cElement.setDeletable(pool.isDeletable());
            cElement.setRenamable(!pool.isNonRenamable());
            cElement.setReadOnly(pool.getOwningParentName() != null);
            elements.addElement(cElement);
            ++idx;
        }
    }

    public static ImageDescriptor getFilterPoolManagerImage(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPoolManager poolMgr) {
        ImageDescriptor poolMgrImage = null;
        if (poolMgrProvider == null) {
            poolMgrProvider = poolMgr.getProvider();
        }
        if (poolMgrProvider != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)poolMgrProvider.getAdapter((Class)clazz);
            poolMgrImage = adapter.getSystemFilterPoolManagerImage();
        }
        if (poolMgrImage == null) {
            poolMgrImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon");
        }
        return poolMgrImage;
    }

    public static ImageDescriptor getFilterPoolImage(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPool pool) {
        ImageDescriptor poolImage = null;
        if (poolMgrProvider == null) {
            poolMgrProvider = pool.getProvider();
        }
        if (poolMgrProvider != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)poolMgrProvider.getAdapter((Class)clazz);
            poolImage = adapter.getSystemFilterPoolImage(pool);
        }
        if (poolImage == null) {
            poolImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon");
        }
        return poolImage;
    }

    public static ImageDescriptor getFilterImage(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilter filter) {
        ImageDescriptor filterImage = null;
        if (poolMgrProvider == null) {
            poolMgrProvider = filter.getProvider();
        }
        if (poolMgrProvider != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)poolMgrProvider.getAdapter((Class)clazz);
            filterImage = adapter.getSystemFilterImage(filter);
        }
        if (filterImage == null) {
            filterImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon");
        }
        return filterImage;
    }
}

