/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.ui.refactoring.includes.HeaderSubstitutionMap;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreationContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeMap;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeUtil;
import org.eclipse.cdt.internal.ui.refactoring.includes.InclusionRequest;
import org.eclipse.cdt.internal.ui.refactoring.includes.SymbolExportMap;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class HeaderSubstitutor {
    private static int HEURISTIC_SCORE_NOT_AUTO_EXPORTED_HEADER = 1;
    private static int HEURISTIC_SCORE_NAME_MATCH = 2;
    private static int HEURISTIC_SCORE_NO_EXTENSION = 4;
    private static int HEURISTIC_SCORE_MAX = HEURISTIC_SCORE_NOT_AUTO_EXPORTED_HEADER + HEURISTIC_SCORE_NAME_MATCH + HEURISTIC_SCORE_NO_EXTENSION;
    private final IncludeCreationContext fContext;
    private IncludeMap[] fIncludeMaps;
    private SymbolExportMap fSymbolExportMap;

    public HeaderSubstitutor(IncludeCreationContext context) {
        List<Object> maps;
        this.fContext = context;
        this.fIncludeMaps = new IncludeMap[]{new IncludeMap(true), new IncludeMap(false)};
        IPreferencesService preferences = Platform.getPreferencesService();
        IScopeContext[] scopes = PreferenceConstants.getPreferenceScopes(context.getProject());
        String str = preferences.getString("org.eclipse.cdt.ui", "organizeIncludes.headerSubstitution", null, scopes);
        if (str != null) {
            maps = HeaderSubstitutionMap.deserializeMaps(str);
            for (Object map : maps) {
                if (((HeaderSubstitutionMap)map).isCppOnly() && !this.fContext.isCXXLanguage()) continue;
                this.fIncludeMaps[0].addAllMappings(((HeaderSubstitutionMap)map).getUnconditionalSubstitutionMap());
                this.fIncludeMaps[1].addAllMappings(((HeaderSubstitutionMap)map).getOptionalSubstitutionMap());
            }
        }
        this.addHeaderDerivedMappings();
        this.fIncludeMaps[0].transitivelyClose();
        this.fIncludeMaps[1].transitivelyClose();
        this.fSymbolExportMap = new SymbolExportMap();
        str = preferences.getString("org.eclipse.cdt.ui", "organizeIncludes.symbolExportingHeaders", null, scopes);
        if (str != null) {
            maps = SymbolExportMap.deserializeMaps(str);
            for (Object map : maps) {
                this.fSymbolExportMap.addAllMappings((SymbolExportMap)map);
            }
        }
    }

    private void addHeaderDerivedMappings() {
        try {
            IIndexFile[] iIndexFileArray = this.fContext.getIndex().getAllFiles();
            int n = iIndexFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFile file = iIndexFileArray[n2];
                String replacement = file.getReplacementHeader();
                if (replacement != null) {
                    IncludeInfo includeInfo;
                    IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
                    if (!this.fContext.getCurrentDirectory().isPrefixOf(path) && (includeInfo = this.fContext.getIncludeForHeaderFile(path)) != null) {
                        if (replacement.isEmpty()) {
                            IIndexInclude[] includedBy = this.fContext.getIndex().findIncludedBy(file, 0);
                            var12_13 = includedBy;
                            var11_12 = includedBy.length;
                            var10_11 = 0;
                            while (var10_11 < var11_12) {
                                String include = var12_13[var10_11];
                                IPath includer = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)include.getIncludedByLocation());
                                replacementInfo = this.fContext.getIncludeForHeaderFile(includer);
                                if (replacementInfo != null) {
                                    this.fIncludeMaps[0].addMapping(includeInfo, replacementInfo);
                                }
                                ++var10_11;
                            }
                        } else {
                            String[] headers;
                            var12_13 = headers = replacement.split(",");
                            var11_12 = headers.length;
                            var10_11 = 0;
                            while (var10_11 < var11_12) {
                                String header = var12_13[var10_11];
                                if (!header.isEmpty()) {
                                    char firstChar = header.charAt(0);
                                    replacementInfo = firstChar == '\"' || firstChar == '<' ? new IncludeInfo(header) : new IncludeInfo(header, includeInfo.isSystem());
                                    this.fIncludeMaps[0].addMapping(includeInfo, replacementInfo);
                                }
                                ++var10_11;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public IPath getUniqueRepresentativeHeader(IPath path) {
        IncludeMap map;
        IncludeMap[] maps;
        IncludeInfo includeInfo = this.fContext.getIncludeForHeaderFile(path);
        if (includeInfo == null) {
            return null;
        }
        IncludeMap[] includeMapArray = maps = this.fIncludeMaps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            map = includeMapArray[n2];
            if (map.isUnconditionalSubstitution()) {
                List<IncludeInfo> replacements = map.getMapping(includeInfo);
                if (replacements.size() == 1) {
                    includeInfo = replacements.get(0);
                } else if (replacements.size() > 1) {
                    return null;
                }
            }
            ++n2;
        }
        includeMapArray = maps;
        n = maps.length;
        n2 = 0;
        while (n2 < n) {
            map = includeMapArray[n2];
            if (!map.isUnconditionalSubstitution() && !map.getMapping(includeInfo).isEmpty()) {
                return null;
            }
            ++n2;
        }
        String filename = includeInfo.getName();
        if (!this.fContext.isHeaderFile(filename) || this.fContext.isAutoExportedFile(filename)) {
            return null;
        }
        return this.fContext.resolveInclude(includeInfo);
    }

    public IPath getPreferredRepresentativeHeader(IPath path) {
        IncludeInfo includeInfo = this.fContext.getIncludeForHeaderFile(path);
        if (includeInfo == null) {
            return path;
        }
        ArrayList<IncludeInfo> candidates = new ArrayList<IncludeInfo>();
        candidates.add(includeInfo);
        IncludeMap[] maps = this.fIncludeMaps;
        IncludeMap[] includeMapArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeMap map = includeMapArray[n2];
            int i = 0;
            while (i < candidates.size()) {
                IncludeInfo candidate = (IncludeInfo)candidates.get(i);
                List<IncludeInfo> replacements = map.getMapping(candidate);
                int increment = 1;
                if (!replacements.isEmpty()) {
                    if (map.isUnconditionalSubstitution()) {
                        candidates.remove(i);
                        increment = 0;
                    }
                    candidates.addAll(i, replacements);
                    increment += replacements.size();
                }
                i += increment;
            }
            ++n2;
        }
        IPath firstResolved = null;
        IPath firstIncludedPreviously = null;
        for (IncludeInfo candidate : candidates) {
            IPath header = this.fContext.resolveInclude(candidate);
            if (header == null) continue;
            if (this.fContext.isIncluded(header)) {
                return header;
            }
            if (firstResolved == null) {
                firstResolved = header;
            }
            if (firstIncludedPreviously != null || !this.fContext.wasIncludedPreviously(header)) continue;
            firstIncludedPreviously = header;
        }
        return firstIncludedPreviously != null ? firstIncludedPreviously : (firstResolved != null ? firstResolved : path);
    }

    public IPath getPreferredRepresentativeHeaderByHeuristic(InclusionRequest request, IPath preferredHeader) {
        if (!this.fContext.isCXXLanguage()) {
            return preferredHeader;
        }
        String symbolName = request.getBinding().getName();
        int bestScore = this.getScore(preferredHeader.toString(), symbolName);
        if (bestScore == HEURISTIC_SCORE_MAX) {
            return preferredHeader;
        }
        IIndexFile bestCandidate = null;
        Set<IIndexFile> indexFiles = request.getDeclaringFiles().keySet();
        ArrayDeque<IIndexFile> front = new ArrayDeque<IIndexFile>();
        HashSet<IIndexFile> processed = new HashSet<IIndexFile>();
        front.addAll(indexFiles);
        processed.addAll(indexFiles);
        try {
            while (!front.isEmpty()) {
                IIndexInclude[] includes;
                IIndexFile file = (IIndexFile)front.remove();
                String path = IncludeUtil.getPath(file);
                int score = this.getScore(path, symbolName);
                if (score > bestScore) {
                    bestScore = score;
                    bestCandidate = file;
                }
                IIndexInclude[] iIndexIncludeArray = includes = this.fContext.getIndex().findIncludedBy(file, 0);
                int n = includes.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexInclude include = iIndexIncludeArray[n2];
                    IIndexFile includer = include.getIncludedBy();
                    if (!processed.contains(includer)) {
                        front.add(includer);
                        processed.add(includer);
                    }
                    ++n2;
                }
            }
            if (bestCandidate != null) {
                return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)bestCandidate.getLocation());
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return preferredHeader;
    }

    private int getScore(String path, String symbolName) {
        int score = 0;
        if (this.fContext.isHeaderFile(path) && !this.fContext.isAutoExportedFile(path)) {
            score += HEURISTIC_SCORE_NOT_AUTO_EXPORTED_HEADER;
        }
        if (HeaderSubstitutor.getFilename(path).equalsIgnoreCase(symbolName)) {
            score += HEURISTIC_SCORE_NAME_MATCH;
        }
        if (!HeaderSubstitutor.hasExtension(path)) {
            score += HEURISTIC_SCORE_NO_EXTENSION;
        }
        return score;
    }

    public Set<IncludeInfo> getExportingHeaders(String symbol) {
        Set<IncludeInfo> headers = this.fSymbolExportMap.getMapping(symbol);
        if (headers == null) {
            return Collections.emptySet();
        }
        return headers;
    }

    private static boolean hasExtension(String path) {
        return path.indexOf(46, path.lastIndexOf(47) + 1) >= 0;
    }

    private static String getFilename(String path) {
        int startPos = path.lastIndexOf(47) + 1;
        int endPos = path.lastIndexOf(46);
        if (endPos > startPos) {
            return path.substring(startPos, endPos);
        }
        return path.substring(startPos);
    }
}

