/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser;

import org.eclipse.datatools.sqltools.sql.parser.Messages;
import org.eclipse.datatools.sqltools.sql.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = -5147769565793762975L;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        int maxSize = this.getExpectedTokenSequencesMaxSize();
        StringBuffer expected = this.buildExpectedTokenMessage();
        StringBuffer retval = this.buildShortMessage(maxSize);
        if (this.expectedTokenSequences.length == 1) {
            retval.append(Messages.ParseException_expecting).append(this.eol).append("    ");
        } else {
            retval.append(Messages.ParseException_expection_oneof).append(this.eol).append("    ");
        }
        retval.append(expected);
        return retval.toString();
    }

    private StringBuffer buildExpectedTokenMessage() {
        StringBuffer expected = new StringBuffer("");
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
                this.tokenImage[this.expectedTokenSequences[i][j]].length();
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
            ++i;
        }
        return expected;
    }

    private StringBuffer buildShortMessage(int maxSize) {
        StringBuffer retval = new StringBuffer(Messages.ParseException_encountered);
        Token tok = this.currentToken.next;
        int i = 0;
        while (i < maxSize) {
            if (i != 0) {
                retval.append(" ");
            }
            if (tok.kind == 0) {
                retval.append(this.tokenImage[0]);
                break;
            }
            retval.append(this.add_escapes(tok.image));
            tok = tok.next;
            ++i;
        }
        retval.append(String.valueOf(Messages.ParseException_period) + this.eol);
        return retval;
    }

    public String getShortMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        int maxSize = this.getExpectedTokenSequencesMaxSize();
        StringBuffer retval = this.buildShortMessage(maxSize);
        return retval.toString();
    }

    private int getExpectedTokenSequencesMaxSize() {
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            ++i;
        }
        return maxSize;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

