/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.vm;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.ui.vm.RegularVMLauncher;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.m2m.atl.engine.vm.AtlSuperimposeModule;
import org.eclipse.m2m.atl.profiler.core.Messages;
import org.eclipse.m2m.atl.profiler.vm.ProfilingDebugger;

public class ProfilerLauncher
extends RegularVMLauncher {
    public Object launch(String mode, IProgressMonitor monitor, Map<String, Object> options, Object ... modules) {
        if (options.get("ATL_FILE") != null) {
            String fileName = options.get("ATL_FILE").toString();
            IFile currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fileName));
            try {
                EObject atlModel = AtlParser.getDefault().parse(currentAtlFile.getContents());
                if (atlModel == null) {
                    throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
                }
                return this.internalLaunch(new ProfilingDebugger(atlModel), options, modules);
            }
            catch (ATLCoreException e) {
                throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
            }
            catch (CoreException e) {
                throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
            }
            catch (AtlSuperimposeModule.AtlSuperimposeModuleException e) {
                throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
            }
        }
        throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
    }

    public String getName() {
        return String.valueOf(super.getName()) + " Profiler";
    }

    public String[] getModes() {
        return new String[]{"run"};
    }
}

