/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class EditorNameAdapter
extends AdapterImpl {
    private IEditingSession editingSession;

    public EditorNameAdapter(IEditingSession editingSession) {
        this.editingSession = editingSession;
    }

    public void notifyChanged(Notification n) {
        Adapter adapter;
        Notifier notifier;
        Object notifier2 = n.getNotifier();
        if (notifier2 instanceof Adapter && (notifier = (adapter = (Adapter)notifier2).getTarget()) instanceof DRepresentationDescriptor) {
            notifier2 = notifier;
        }
        if (notifier2 instanceof DRepresentationDescriptor && n.getFeatureID(DRepresentationDescriptor.class) == 3) {
            ArrayList<IEditorInput> mades = new ArrayList<IEditorInput>();
            for (IEditorPart iEditorPart : this.editingSession.getEditors()) {
                if (iEditorPart instanceof SessionListener) {
                    ((SessionListener)iEditorPart).notify(1);
                }
                if (!(iEditorPart.getEditorInput() instanceof SessionEditorInput) || mades.contains(iEditorPart.getEditorInput())) continue;
                mades.add(iEditorPart.getEditorInput());
                this.updateEditorInputName((SessionEditorInput)iEditorPart.getEditorInput(), iEditorPart);
            }
        }
    }

    private void updateEditorInputName(final SessionEditorInput editorInput, final IEditorPart editor) {
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                editorInput.setName(editor.getTitle());
            }
        });
    }

    public void registerEditor(DialectEditor editor) {
        DRepresentationDescriptor representationDescriptor;
        DRepresentation representation = editor.getRepresentation();
        if (representation != null && (representationDescriptor = new DRepresentationQuery(representation).getRepresentationDescriptor()) != null) {
            representationDescriptor.eAdapters().add((Object)this);
        }
    }

    public void unregisterEditor(DialectEditor editor) {
        block3: {
            DRepresentationDescriptor representationDescriptor;
            DRepresentation representation = editor.getRepresentation();
            if (representation != null && (representationDescriptor = new DRepresentationQuery(representation).getRepresentationDescriptor()) != null && representationDescriptor.eAdapters().contains((Object)this)) {
                try {
                    representationDescriptor.eAdapters().remove((Object)this);
                }
                catch (NullPointerException nullPointerException) {
                    if (!SiriusEditPlugin.getPlugin().isDebugging()) break block3;
                    SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.ui", Messages.EditorNameAdapter_representationClosingError));
                }
            }
        }
    }
}

