/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TabFactory {
    private final TabItem m_item;

    private TabFactory(TabItem item) {
        this.m_item = item;
    }

    public static TabFactory item(TabFolder folder) {
        return TabFactory.item(folder, 0);
    }

    public static TabFactory item(TabFolder folder, int style) {
        return new TabFactory(new TabItem(folder, style));
    }

    public TabFactory text(String text) {
        this.m_item.setText(text);
        return this;
    }

    public TabFactory tooltip(String text) {
        this.m_item.setToolTipText(text);
        return this;
    }

    public TabFactory control(Control control) {
        this.m_item.setControl(control);
        return this;
    }

    public Composite composite() {
        Composite composite = new Composite((Composite)this.m_item.getParent(), 0);
        this.m_item.setControl((Control)composite);
        return composite;
    }

    public TabFactory image(Image value) {
        this.m_item.setImage(value);
        return this;
    }

    public TabFactory data(Object value) {
        this.m_item.setData(value);
        return this;
    }
}

