/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.tree;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.gef.core.AbstractEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.tree.RootEditPart;
import org.eclipse.wb.internal.gef.tree.TreeEventManager;

public class TreeViewer
extends AbstractEditPartViewer {
    private Tree m_tree;
    private RootEditPart m_rootEditPart;
    private TreeEventManager m_eventManager;

    @Override
    public Control createControl(Composite parent) {
        this.m_tree = new Tree(parent, 770);
        this.m_eventManager = new TreeEventManager(this.m_tree, this);
        this.m_rootEditPart = new RootEditPart();
        this.m_rootEditPart.setViewer(this);
        this.m_rootEditPart.activate();
        this.setRootEditPart(this.m_rootEditPart);
        this.synchronizeSelection();
        return this.m_tree;
    }

    public Tree getControl() {
        return this.m_tree;
    }

    @Override
    public int getHOffset() {
        return 0;
    }

    @Override
    public int getVOffset() {
        return 0;
    }

    public RootEditPart getRootEditPart() {
        return this.m_rootEditPart;
    }

    @Override
    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.m_eventManager.setDomain(domain);
    }

    public void setCursor(Cursor cursor) {
        this.m_tree.setCursor(cursor);
    }

    private void synchronizeSelection() {
        final boolean[] inTreeSelectionListener = new boolean[1];
        this.m_tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = TreeViewer.this.m_tree.getSelection();
                Object[] selection = new EditPart[items.length];
                int i = 0;
                while (i < selection.length) {
                    selection[i] = (EditPart)items[i].getData();
                    ++i;
                }
                try {
                    inTreeSelectionListener[0] = true;
                    TreeViewer.this.setSelection((ISelection)new StructuredSelection(selection));
                }
                finally {
                    inTreeSelectionListener[0] = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!inTreeSelectionListener[0]) {
                    TreeViewer.this.setSelectionToTreeWidget();
                }
            }
        });
    }

    public void setSelectionToTreeWidget() {
        ArrayList<TreeItem> treeItems = new ArrayList<TreeItem>();
        for (EditPart editPart : this.getSelectedEditParts()) {
            TreeEditPart treeEditPart = (TreeEditPart)editPart;
            treeItems.add(treeEditPart.getWidget());
        }
        this.m_tree.setSelection(treeItems.toArray(new TreeItem[treeItems.size()]));
    }

    public EditPart findObjectAtExcluding(Point location, Collection<IFigure> exclude, EditPartViewer.Conditional conditional) {
        Rectangle clientArea = this.m_tree.getClientArea();
        if (location.x < 0 || location.y < 0 || location.x > clientArea.width || location.y > clientArea.height) {
            return null;
        }
        RootEditPart result = null;
        TreeItem item = this.m_tree.getItem(new org.eclipse.swt.graphics.Point(location.x, location.y));
        result = item == null ? this.m_rootEditPart : (EditPart)item.getData();
        while (result != null) {
            if (conditional == null || conditional.evaluate((EditPart)result)) {
                return result;
            }
            result = result.getParent();
        }
        return null;
    }

    @Override
    public EditPart findObjectAtExcluding(Point location, Collection<IFigure> exclude, EditPartViewer.Conditional conditional, String layer) {
        return null;
    }
}

