/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWGlobalVariable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWGlobalVariableImpl;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Schema;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogGlobalVariable
extends LUWGlobalVariableImpl
implements ICatalogObject {
    private boolean privilegeLoaded = false;

    public void refresh() {
        this.privilegeLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getPrivileges();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogGlobalVariable.loadPrivileges(this.getConnection(), privileges, this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    protected static void loadPrivileges(Connection connection, EList privilegeList, LUWGlobalVariable variable, String granteeFilter) throws SQLException {
        DB2Schema schema = variable.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        int options = ((LUWCatalogDatabase)database).getLoadOptions();
        if ((options & 0x800) == 2048) {
            return;
        }
        Statement s = connection.createStatement();
        String query = "SELECT GRANTOR,GRANTORTYPE,GRANTEE,GRANTEETYPE,READAUTH,WRITEAUTH FROM SYSCAT.VARIABLEAUTH WHERE VARSCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'" + " AND VARNAME='" + LUWUtil.getIdentifier(variable.getName()) + "'";
        if (granteeFilter != null && !"".equals(granteeFilter)) {
            query = String.valueOf(query) + " AND " + granteeFilter;
        }
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String writeAuth;
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                String grantorType = r.getString("GRANTORTYPE");
                boolean isSystemGranted = "S".equals(grantorType);
                String readAuth = r.getString("READAUTH");
                if (!readAuth.equals("N")) {
                    LUWCatalogPrivilege privilege = new LUWCatalogPrivilege();
                    privilege.setAction("READ");
                    if (readAuth.equals("G")) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if ((writeAuth = r.getString("WRITEAUTH")).equals("N")) continue;
                LUWCatalogPrivilege privilege = new LUWCatalogPrivilege();
                privilege.setAction("WRITE");
                if (writeAuth.equals("G")) {
                    privilege.setGrantable(true);
                }
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }
}

