/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.figures.GFMultilineText;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.services.ITraceService;

public class TraceService
implements ITraceService {
    private final boolean FULL_QUALIFIED = false;
    private final boolean ADD_OBJECT_INFO = false;
    private final boolean ADD_STYLE_INFO = false;

    @Override
    public String getStacktrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public void dumpFigureTree(IFigure figure) {
        System.out.println("\nFigure Tree");
        this.dumpFigureTree(figure, 0);
    }

    @Override
    public void dumpFigureTree(IFigure figure, int indent) {
        String indentString = this.createIndentString(indent);
        Object additional = "";
        if (figure instanceof Label) {
            Label label = (Label)figure;
            additional = " (text: " + label.getText() + ")";
        }
        if (figure instanceof GFMultilineText) {
            GFMultilineText mlt = (GFMultilineText)figure;
            additional = (String)additional + " (text: " + mlt.getText() + ")";
        }
        if (!figure.isVisible()) {
            additional = (String)additional + " (NOT visible)";
        }
        additional = (String)additional + " (" + String.valueOf(figure.getBounds()) + ")";
        System.out.println(indentString + this.getClassName(figure, false) + (String)additional);
        List children = figure.getChildren();
        for (IFigure childFigure : children) {
            this.dumpFigureTree(childFigure, indent + 2);
        }
    }

    @Override
    public void dumpFigureTreeWithConnectionLayer(IFigure figure) {
        IFigure dumpRoot = figure;
        FreeformLayeredPane root = this.findFreeformLayeredPane(dumpRoot);
        if (root != null) {
            dumpRoot = root;
        }
        this.dumpFigureTree(dumpRoot);
    }

    private FreeformLayeredPane findFreeformLayeredPane(IFigure figure) {
        IFigure parentFigure = figure.getParent();
        if (parentFigure instanceof FreeformLayeredPane) {
            return (FreeformLayeredPane)parentFigure;
        }
        if (parentFigure != null) {
            return this.findFreeformLayeredPane(parentFigure);
        }
        return null;
    }

    @Override
    public void dumpEditPartTree(EditPart editPart) {
        System.out.println("\nEdit Part Tree()");
        this.dumpEditPartTree(editPart, 0);
    }

    @Override
    public void dumpEditPartTree(EditPart editPart, int indent) {
        PictogramElement pe;
        GraphicsAlgorithm ga;
        String indentString = this.createIndentString(indent);
        Object m = editPart.getModel();
        Object additional = "";
        if (m instanceof PictogramElement && (ga = (pe = (PictogramElement)m).getGraphicsAlgorithm()) != null) {
            additional = (String)additional + " (" + this.getClassName(ga, false) + ")";
        }
        System.out.println(indentString + this.getClassName(editPart, false) + (String)additional);
        List<EditPart> ch = GraphitiUiInternal.getGefService().getEditPartChildren(editPart);
        for (EditPart epChild : ch) {
            this.dumpEditPartTree(epChild, indent + 2);
        }
    }

    @Override
    public void dumpPictogramModelTree(PictogramElement pe) {
        System.out.println("\nPictogram Model Tree()");
        this.dumpPictogramModelTree(pe, 0);
    }

    @Override
    public void dumpPictogramModelTree(PictogramElement pe, int indent) {
        String indentString = this.createIndentString(indent);
        Object additional = "";
        additional = (String)additional + " (" + (pe.isActive() ? "active" : "inactive") + ")";
        additional = (String)additional + " (" + (pe.isVisible() ? "visible" : "invisible") + ")";
        System.out.println(indentString + "*PE* " + this.getClassName(pe, false) + (String)additional);
        this.dumpGATree(pe.getGraphicsAlgorithm(), indent + 2);
        Collection peChildren = Graphiti.getPeService().getPictogramElementChildren(pe);
        for (PictogramElement peChild : peChildren) {
            this.dumpPictogramModelTree(peChild, indent + 2);
        }
    }

    @Override
    public void dumpGATree(GraphicsAlgorithm ga) {
        this.dumpGATree(ga, 0);
    }

    @Override
    public void dumpGATree(GraphicsAlgorithm ga, int indent) {
        String indentString = this.createIndentString(indent);
        if (ga == null) {
            return;
        }
        Object additional = "";
        IDimension size = Graphiti.getGaService().calculateSize(ga);
        additional = (String)additional + " (" + ga.getX() + ", " + ga.getY() + ", " + size.getWidth() + ", " + size.getHeight() + ")";
        System.out.println(indentString + this.getClassName(ga, false) + (String)additional);
        EList gaChildren = ga.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm gaChild : gaChildren) {
            this.dumpGATree(gaChild, indent + 2);
        }
    }

    public void dumpStyleTree(Style style) {
        this.dumpStyleTree(style, 0);
    }

    public void dumpStyleTree(Style style, int indent) {
        String indentString = this.createIndentString(indent);
        if (style == null) {
            return;
        }
        Object additional = "";
        String styleId = style.getId();
        if (styleId != null) {
            additional = (String)additional + " (" + styleId + ")";
        }
        System.out.println(indentString + this.getClassName(style, false) + (String)additional);
        EObject eC = style.eContainer();
        if (eC instanceof Style) {
            Style parentStyle = (Style)eC;
            this.dumpStyleTree(parentStyle, indent + 2);
        }
    }

    private String getClassName(Object o, boolean fullQualified) {
        if (fullQualified) {
            return o.getClass().getName();
        }
        return o.getClass().getSimpleName();
    }

    private String createIndentString(int indent) {
        int s = 0;
        Object indentString = "";
        while (s < indent) {
            indentString = (String)indentString + " ";
            ++s;
        }
        return indentString;
    }

    private String getObjectInfo(Object o) {
        return o.toString();
    }
}

