/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.launch.MavenEmbeddedRuntime;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;
import org.eclipse.m2e.internal.launch.MavenRuntimeLaunchSupport;
import org.eclipse.m2e.internal.maven.listener.M2EMavenBuildDataBridge;

public class MavenBuildProjectDataConnection {
    private static final Map<ILaunch, MavenBuildConnectionData> LAUNCH_PROJECT_DATA = new ConcurrentHashMap<ILaunch, MavenBuildConnectionData>();

    static {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

            public void launchesRemoved(ILaunch[] launches) {
                1.closeServers(Arrays.stream(launches).map(LAUNCH_PROJECT_DATA::remove));
            }

            public void launchesTerminated(ILaunch[] launches) {
                1.closeServers(Arrays.stream(launches).map(LAUNCH_PROJECT_DATA::get));
            }

            private static void closeServers(Stream<MavenBuildConnectionData> connectionData) {
                connectionData.filter(Objects::nonNull).forEach(c -> {
                    try {
                        c.connection().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }
        });
    }

    static void openListenerConnection(ILaunch launch, MavenRuntimeLaunchSupport.VMArguments arguments) {
        try {
            if (MavenLaunchUtils.getMavenRuntime(launch.getLaunchConfiguration()) instanceof MavenEmbeddedRuntime) {
                ConcurrentHashMap<ArtifactKey, M2EMavenBuildDataBridge.MavenProjectBuildData> projects = new ConcurrentHashMap<ArtifactKey, M2EMavenBuildDataBridge.MavenProjectBuildData>();
                M2EMavenBuildDataBridge.MavenBuildConnection connection = M2EMavenBuildDataBridge.prepareConnection((String)launch.getLaunchConfiguration().getName(), d -> {
                    M2EMavenBuildDataBridge.MavenProjectBuildData mavenProjectBuildData = projects.put(new ArtifactKey(d.groupId, d.artifactId, d.version, null), (M2EMavenBuildDataBridge.MavenProjectBuildData)d);
                });
                if (LAUNCH_PROJECT_DATA.putIfAbsent(launch, new MavenBuildConnectionData(projects, connection)) != null) {
                    connection.close();
                    throw new IllegalStateException("Maven bridge already created for launch of" + launch.getLaunchConfiguration().getName());
                }
                arguments.append(connection.getMavenVMArguments());
            }
        }
        catch (IOException | CoreException throwable) {
            // empty catch block
        }
    }

    static M2EMavenBuildDataBridge.MavenProjectBuildData getBuildProject(ILaunch launch, String groupId, String artifactId, String version) {
        MavenBuildConnectionData build = LAUNCH_PROJECT_DATA.get(launch);
        if (build == null) {
            return null;
        }
        ArtifactKey key = new ArtifactKey(groupId, artifactId, version, null);
        M2EMavenBuildDataBridge.MavenProjectBuildData buildProject;
        while ((buildProject = build.projects().get(key)) == null && !build.connection().isReadCompleted()) {
            Thread.onSpinWait();
        }
        return buildProject;
    }

    private record MavenBuildConnectionData(Map<ArtifactKey, M2EMavenBuildDataBridge.MavenProjectBuildData> projects, M2EMavenBuildDataBridge.MavenBuildConnection connection) {
    }
}

