/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplClassic;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class FormUtils {
    private FormUtils() {
    }

    public static <C extends ControlInfo> List<C> getAttachableControls(IFormLayoutInfo<C> layout, C firstControl, boolean horizontal) throws Exception {
        int side = horizontal ? 1 : 8;
        FormLayoutInfoImplClassic impl = (FormLayoutInfoImplClassic)layout.getImpl();
        return impl.getAlignControlInfos(firstControl, side);
    }

    public static <C extends IControlInfo> List<C> getAttachableControls(IFormLayoutInfo<C> layout) {
        return layout.getControls();
    }

    public static <C extends IControlInfo> String getVariableName(C child) {
        return (String)ExecutionUtils.runObjectIgnore(() -> child.getPresentation().getText(), (Object)"<unknown>");
    }

    public static boolean between(int x, int a, int b) {
        return x >= a && x <= b;
    }

    public static int snapGrid(int value, int snap) {
        return FormUtils.applyGrid(value, snap);
    }

    private static int applyGrid(int value, int step) {
        return value / step * step;
    }

    public static <C extends IControlInfo> int getLayoutMarginLeft(IFormLayoutInfo<C> layout) {
        return FormUtils.getLayoutMargin(layout, "marginLeft") + FormUtils.getLayoutMargin(layout, "marginWidth");
    }

    public static <C extends IControlInfo> int getLayoutMarginRight(IFormLayoutInfo<C> layout) {
        return FormUtils.getLayoutMargin(layout, "marginRight") + FormUtils.getLayoutMargin(layout, "marginWidth");
    }

    public static <C extends IControlInfo> int getLayoutMarginTop(IFormLayoutInfo<C> layout) {
        return FormUtils.getLayoutMargin(layout, "marginTop") + FormUtils.getLayoutMargin(layout, "marginHeight");
    }

    public static <C extends IControlInfo> int getLayoutMarginBottom(IFormLayoutInfo<C> layout) {
        return FormUtils.getLayoutMargin(layout, "marginBottom") + FormUtils.getLayoutMargin(layout, "marginHeight");
    }

    public static <C extends IControlInfo> Insets getLayoutMargins(IFormLayoutInfo<C> layout) {
        return new Insets(FormUtils.getLayoutMarginTop(layout), FormUtils.getLayoutMarginLeft(layout), FormUtils.getLayoutMarginBottom(layout), FormUtils.getLayoutMarginRight(layout));
    }

    private static <C extends IControlInfo> int getLayoutMargin(IFormLayoutInfo<C> layout, String marginSide) {
        try {
            return (Integer)layout.getPropertyByTitle(marginSide).getValue();
        }
        catch (Throwable e) {
            ReflectionUtils.propagate((Throwable)e);
            return 0;
        }
    }
}

