/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.util;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSDLResourceFactoryRegistry
extends ResourceFactoryRegistryImpl {
    protected Resource.Factory.Registry parent;

    public WSDLResourceFactoryRegistry(Resource.Factory.Registry parent) {
        this.parent = parent;
    }

    public Map getExtensionToFactoryMap() {
        return this.parent.getExtensionToFactoryMap();
    }

    public Map getProtocolToFactoryMap() {
        return this.parent.getProtocolToFactoryMap();
    }

    public Resource.Factory getFactory(URI uri) {
        return this.getFactory(uri, null);
    }

    public Resource.Factory getFactory(URI uri, String contentType) {
        String uriString = uri.toString();
        Resource.Factory factory = this.parent.getFactory(uri, contentType);
        Resource.Factory defaultFactory = INSTANCE.getFactory(URI.createURI((String)"*"), contentType);
        if (factory == null || factory == defaultFactory) {
            if (uriString.endsWith("wsdl") || uriString.endsWith("WSDL")) {
                factory = this.parent.getFactory(URI.createURI((String)"*.wsdl"), contentType);
            } else if (uriString.endsWith("xsd") || uriString.endsWith("XSD")) {
                factory = this.parent.getFactory(URI.createURI((String)"*.xsd"), contentType);
            } else {
                String rootElementName = this.getRootElementName(uriString);
                if (rootElementName != null) {
                    if (rootElementName.equals("schema")) {
                        factory = this.parent.getFactory(URI.createURI((String)"*.xsd"), contentType);
                    } else if (rootElementName.equals("definitions")) {
                        factory = this.parent.getFactory(URI.createURI((String)"*.wsdl"), contentType);
                    }
                }
            }
        }
        return factory;
    }

    private String getRootElementName(String uri) {
        RootElementNameContentHandler handler = new RootElementNameContentHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(uri);
        }
        catch (Exception exception) {}
        return handler.rootElementName;
    }

    protected static class RootElementNameContentHandler
    extends DefaultHandler {
        public String rootElementName;

        protected RootElementNameContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.rootElementName = localName;
            throw new SAXException("SAXParser intentonally stopped");
        }
    }
}

