/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.cm;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.annotation.config.WithConfigurations;
import org.osgi.test.common.annotation.config.WithFactoryConfiguration;
import org.osgi.test.common.annotation.config.WithFactoryConfigurations;
import org.osgi.test.common.dictionary.Dictionaries;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.junit5.cm.AnnotationUtil;
import org.osgi.test.junit5.cm.BlockingConfigurationHandler;
import org.osgi.test.junit5.cm.BlockingConfigurationHandlerImpl;
import org.osgi.test.junit5.cm.ConfigCloseableResource;
import org.osgi.test.junit5.cm.ConfigUtil;
import org.osgi.test.junit5.cm.ConfigurationCopy;
import org.osgi.test.junit5.cm.ConfigurationHolder;
import org.osgi.test.junit5.inject.InjectingExtension;
import org.osgi.test.junit5.properties.PropertiesConverter;
import org.osgi.test.junit5.service.ServiceExtension;

public class ConfigurationExtension
extends InjectingExtension<InjectConfiguration>
implements BeforeEachCallback,
ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String STORE_CONFIG_HANDLER = "store.config.handler";
    private static final String STORE_CONFIG_HANDLER_REG = "store.config.handler.reg";
    private static final String STORE_CONFIGURATION_CLASS_KEY = "store.configurationAdmin.class";
    private static final String STORE_CONFIGURATION_BA_KEY = "store.configurationAdmin.beforeAll";
    private static final String STORE_CONFIGURATION_BE_KEY = "store.configurationAdmin.beforeEach";
    private static final String STORE_CONFIGURATION_TEST_KEY = "store.configurationAdmin.test";
    private static ExtensionContext DO_NOT_USE_CONTEXT;

    public ConfigurationExtension() {
        super(InjectConfiguration.class, new Class[0]);
    }

    public static ConfigurationAdmin configurationAdmin(ExtensionContext extensionContext) {
        return (ConfigurationAdmin)ServiceExtension.getServiceConfiguration(ConfigurationAdmin.class, (String)"", (String[])new String[0], (int)0, (long)0L, (ExtensionContext)extensionContext).getService();
    }

    private static BlockingConfigurationHandler getBlockingConfigurationHandler(ExtensionContext extensionContext) {
        BlockingConfigurationHandlerImpl impl = (BlockingConfigurationHandlerImpl)ConfigurationExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)STORE_CONFIG_HANDLER, y -> new BlockingConfigurationHandlerImpl(extensionContext.getTestClass()), BlockingConfigurationHandlerImpl.class);
        return impl;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        DO_NOT_USE_CONTEXT = extensionContext.getRoot();
        List<ConfigurationHolder> list = this.handleAnnotationsOnActiveElement(extensionContext);
        this.storeConfigCopy(extensionContext, list, STORE_CONFIGURATION_CLASS_KEY);
        this.storeConfigCopy(extensionContext, Collections.emptyList(), STORE_CONFIGURATION_BA_KEY);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        this.clearConfigurations(extensionContext, STORE_CONFIGURATION_BA_KEY);
        this.clearConfigurations(extensionContext, STORE_CONFIGURATION_CLASS_KEY);
        ServiceRegistration svc = (ServiceRegistration)ConfigurationExtension.getStore(extensionContext.getRoot()).remove((Object)STORE_CONFIG_HANDLER_REG, ServiceRegistration.class);
        if (svc != null) {
            try {
                svc.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.storeConfigCopy(extensionContext, Collections.emptyList(), STORE_CONFIGURATION_BE_KEY);
        super.beforeEach(extensionContext);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        super.afterEach(extensionContext);
        this.clearConfigurations(extensionContext, STORE_CONFIGURATION_BE_KEY);
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        List<ConfigurationHolder> list = this.handleAnnotationsOnActiveElement(extensionContext);
        this.storeConfigCopy(extensionContext, list, STORE_CONFIGURATION_TEST_KEY);
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        this.clearConfigurations(extensionContext, STORE_CONFIGURATION_TEST_KEY);
    }

    private void clearConfigurations(ExtensionContext extensionContext, String key) {
        ConfigCloseableResource resource = (ConfigCloseableResource)ConfigurationExtension.getStore(extensionContext).remove((Object)key, ConfigCloseableResource.class);
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to delete test configuration", e);
            }
        }
    }

    private ConfigurationHolder handleWithConfiguration(ExtensionContext context, WithConfiguration configAnnotation, ConfigurationAdmin configurationAdmin, boolean injecting) {
        try {
            Configuration configBefore = ConfigUtil.getConfigsByServicePid(configurationAdmin, configAnnotation.pid(), 0L);
            Optional<ConfigurationCopy> copyOfBefore = this.createConfigurationCopy(configBefore);
            Configuration configuration = "org.osgi.test.common.annotation.notset".equals(configAnnotation.location()) ? configurationAdmin.getConfiguration(configAnnotation.pid(), null) : configurationAdmin.getConfiguration(configAnnotation.pid(), configAnnotation.location());
            this.updateConfigurationRespectNew(context, configuration, PropertiesConverter.of((ExtensionContext)context, (Property[])configAnnotation.properties()), configBefore == null, injecting);
            return new ConfigurationHolder(configuration, copyOfBefore);
        }
        catch (Exception e) {
            throw new ParameterResolutionException(String.format("Unable to obtain Configuration for %s.", configAnnotation.pid()), (Throwable)e);
        }
    }

    private ConfigurationHolder handleWithFactoryConfiguration(ExtensionContext context, WithFactoryConfiguration configAnnotation, ConfigurationAdmin configurationAdmin, boolean injecting) {
        try {
            Configuration configuration;
            Configuration configBefore;
            if ("org.osgi.test.common.annotation.notset".equals(configAnnotation.name())) {
                configBefore = null;
                configuration = "org.osgi.test.common.annotation.notset".equals(configAnnotation.location()) ? configurationAdmin.createFactoryConfiguration(configAnnotation.factoryPid(), null) : configurationAdmin.createFactoryConfiguration(configAnnotation.factoryPid(), configAnnotation.location());
            } else {
                configBefore = ConfigUtil.getConfigsByServicePid(configurationAdmin, configAnnotation.factoryPid() + "~" + configAnnotation.name(), 0L);
                configuration = "org.osgi.test.common.annotation.notset".equals(configAnnotation.location()) ? configurationAdmin.getFactoryConfiguration(configAnnotation.factoryPid(), configAnnotation.name(), null) : configurationAdmin.getFactoryConfiguration(configAnnotation.factoryPid(), configAnnotation.name(), configAnnotation.location());
            }
            this.updateConfigurationRespectNew(context, configuration, PropertiesConverter.of((ExtensionContext)context, (Property[])configAnnotation.properties()), configBefore == null, injecting);
            return new ConfigurationHolder(configuration, this.createConfigurationCopy(configBefore));
        }
        catch (Exception e) {
            throw new ParameterResolutionException(String.format("Unable to obtain Configuration for %s.", configAnnotation.factoryPid()), (Throwable)e);
        }
    }

    private Optional<ConfigurationCopy> createConfigurationCopy(Configuration configBefore) {
        Optional<ConfigurationCopy> copyOfBefore = configBefore == null ? Optional.empty() : Optional.of(ConfigurationCopy.of(configBefore));
        return copyOfBefore;
    }

    protected boolean supportsType(TargetType targetType, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (targetType.matches(Configuration.class)) {
            return true;
        }
        if (targetType.matches(Optional.class, new Type[]{Configuration.class})) {
            return true;
        }
        if (targetType.matches(Map.class, new Type[]{String.class, Object.class})) {
            return true;
        }
        if (targetType.matches(Dictionary.class, new Type[]{String.class, Object.class})) {
            return true;
        }
        throw new ParameterResolutionException(String.format("Element %s has an unsupported type %s for annotation @%s. Supported types are: Configuration, Optional<Configuration>, Map<String,Object>, Dictionary<String,Object>.", targetType.getName(), targetType.getType().getName(), this.annotation().getSimpleName()));
    }

    protected int disallowedFieldModifiers() {
        return super.disallowedFieldModifiers() | 8;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return super.supportsParameter(parameterContext, extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return super.resolveParameter(parameterContext, extensionContext);
    }

    protected Object resolveValue(TargetType targetType, InjectConfiguration injectConfiguration, ExtensionContext extensionContext) throws ParameterResolutionException {
        int option = 0;
        if (!injectConfiguration.value().equals("org.osgi.test.common.annotation.notset")) {
            ++option;
        }
        if (!injectConfiguration.withConfig().pid().equals("org.osgi.test.common.annotation.notset")) {
            option += 2;
        }
        if (!injectConfiguration.withFactoryConfig().factoryPid().equals("org.osgi.test.common.annotation.notset")) {
            option += 4;
        }
        Configuration configuration = null;
        ConfigurationHolder configurationHolder = null;
        switch (option) {
            case 1: {
                try {
                    configuration = ConfigUtil.getConfigsByServicePid(ConfigurationExtension.configurationAdmin(extensionContext), injectConfiguration.value(), injectConfiguration.timeout());
                    if (configuration == null) break;
                    ConfigurationCopy cCopy = ConfigurationCopy.of(configuration);
                    configurationHolder = new ConfigurationHolder(configuration, Optional.of(cCopy));
                    break;
                }
                catch (Exception e) {
                    throw new ParameterResolutionException(String.format("Unable to obtain Configuration for %s.", injectConfiguration.value()), (Throwable)e);
                }
            }
            case 2: {
                configurationHolder = this.handleWithConfiguration(extensionContext, injectConfiguration.withConfig(), ConfigurationExtension.configurationAdmin(extensionContext), true);
                configuration = configurationHolder.getCmConfiguration();
                break;
            }
            case 4: {
                configurationHolder = this.handleWithFactoryConfiguration(extensionContext, injectConfiguration.withFactoryConfig(), ConfigurationExtension.configurationAdmin(extensionContext), true);
                configuration = configurationHolder.getCmConfiguration();
                break;
            }
            default: {
                throw new ParameterResolutionException(String.format("@%s - one of the Fields `value`, `withConfig` or `withFactoryConfig` must be used.", this.annotation().getSimpleName()));
            }
        }
        if (configurationHolder != null) {
            this.storeConfigCopy(extensionContext, configurationHolder, this.getFinestScopeKey(extensionContext));
        }
        if (targetType.matches(Configuration.class)) {
            return configuration;
        }
        if (targetType.matches(Optional.class, new Type[]{Configuration.class})) {
            return Optional.ofNullable(configuration);
        }
        if (targetType.matches(Map.class, new Type[]{String.class, Object.class})) {
            if (configuration == null) {
                return null;
            }
            return Dictionaries.asMap((Dictionary)configuration.getProperties());
        }
        if (targetType.matches(Dictionary.class, new Type[]{String.class, Object.class})) {
            if (configuration == null) {
                return null;
            }
            return configuration.getProperties();
        }
        throw new ParameterResolutionException(String.format("Element %s has an unsupported type %s for annotation @%s. Supported types are: Configuration, Optional<Configuration>, Map<String,Object>, Dictionary<String,Object>.", targetType.getName(), targetType.getType().getName(), this.annotation().getSimpleName()));
    }

    private String getFinestScopeKey(ExtensionContext extensionContext) {
        ExtensionContext.Store store = ConfigurationExtension.getStore(extensionContext);
        if (store.get((Object)STORE_CONFIGURATION_TEST_KEY) != null) {
            return STORE_CONFIGURATION_TEST_KEY;
        }
        if (store.get((Object)STORE_CONFIGURATION_BE_KEY) != null) {
            return STORE_CONFIGURATION_BE_KEY;
        }
        if (store.get((Object)STORE_CONFIGURATION_BA_KEY) != null) {
            return STORE_CONFIGURATION_BA_KEY;
        }
        throw new IllegalStateException("Unable to determine the current injection scope");
    }

    private List<ConfigurationHolder> handleAnnotationsOnActiveElement(ExtensionContext extensionContext) {
        ConfigurationAdmin ca = ConfigurationExtension.configurationAdmin(extensionContext);
        return extensionContext.getElement().map(AnnotationUtil::findAllConfigAnnotations).orElse(Collections.emptyList()).stream().flatMap(annotation -> this.handleConfiguration(extensionContext, (Annotation)annotation, ca).stream()).collect(Collectors.toList());
    }

    private List<ConfigurationHolder> handleConfiguration(ExtensionContext extensionContext, Annotation an, ConfigurationAdmin ca) {
        ArrayList<ConfigurationHolder> configHolders = new ArrayList<ConfigurationHolder>();
        if (an instanceof WithConfigurations) {
            WithConfigurations withConfigurations = (WithConfigurations)an;
            for (WithConfiguration factoryConfigAnnotation : withConfigurations.value()) {
                configHolders.add(this.handleWithConfiguration(extensionContext, factoryConfigAnnotation, ca, false));
            }
        } else if (an instanceof WithConfiguration) {
            configHolders.add(this.handleWithConfiguration(extensionContext, (WithConfiguration)an, ca, false));
        } else if (an instanceof WithFactoryConfigurations) {
            WithFactoryConfigurations withFactoryConfigurations = (WithFactoryConfigurations)an;
            for (WithFactoryConfiguration factoryConfigAnnotation : withFactoryConfigurations.value()) {
                configHolders.add(this.handleWithFactoryConfiguration(extensionContext, factoryConfigAnnotation, ca, false));
            }
        } else if (an instanceof WithFactoryConfiguration) {
            configHolders.add(this.handleWithFactoryConfiguration(extensionContext, (WithFactoryConfiguration)an, ca, false));
        }
        return configHolders;
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ConfigurationExtension.class, extensionContext.getUniqueId()}));
    }

    private void storeConfigCopy(ExtensionContext extensionContext, List<ConfigurationHolder> configurationHolders, String key) {
        ConfigCloseableResource ccr = (ConfigCloseableResource)ConfigurationExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)key, k -> new ConfigCloseableResource(extensionContext, ConfigurationExtension.getBlockingConfigurationHandler(extensionContext)), ConfigCloseableResource.class);
        ccr.addAll(configurationHolders);
    }

    private void storeConfigCopy(ExtensionContext extensionContext, ConfigurationHolder configurationHolder, String key) {
        this.storeConfigCopy(extensionContext, Collections.singletonList(configurationHolder), key);
    }

    @Deprecated
    public void updateConfigurationRespectNew(Configuration configurationToBeUpdated, Dictionary<String, Object> newConfigurationProperties, boolean isNewConfiguration) throws InterruptedException, IOException {
        this.updateConfigurationRespectNew(DO_NOT_USE_CONTEXT, configurationToBeUpdated, newConfigurationProperties, isNewConfiguration, false);
    }

    private void updateConfigurationRespectNew(ExtensionContext extensionContext, Configuration configurationToBeUpdated, Dictionary<String, Object> newConfigurationProperties, boolean isNewConfiguration, boolean injecting) throws InterruptedException, IOException {
        if (configurationToBeUpdated != null) {
            BlockingConfigurationHandler blockingConfigHandler = ConfigurationExtension.getBlockingConfigurationHandler(extensionContext);
            if (newConfigurationProperties != null) {
                if (ConfigUtil.isDictionaryWithNotSetMarker(newConfigurationProperties)) {
                    if (isNewConfiguration && !injecting) {
                        blockingConfigHandler.update(configurationToBeUpdated, Dictionaries.dictionaryOf(), 1000L);
                    }
                } else {
                    blockingConfigHandler.update(configurationToBeUpdated, newConfigurationProperties, 1000L);
                }
            } else if (isNewConfiguration) {
                blockingConfigHandler.update(configurationToBeUpdated, Dictionaries.dictionaryOf(), 1000L);
            }
        }
    }
}

