/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect;

import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;

public class FullSelectTableElement {
    QueryExpressionBody queryExprBody;
    QueryCombined parent;
    QueryCombinedOperator operator;

    public FullSelectTableElement(QueryExpressionBody query, QueryCombinedOperator opr, QueryCombined parentNode) {
        this.queryExprBody = query;
        this.operator = opr;
        this.parent = parentNode;
    }

    public QueryExpressionBody getQuery() {
        return this.queryExprBody;
    }

    public String getColumnText(int columnIndex) {
        String colText = "";
        if (columnIndex == 0) {
            if (this.queryExprBody != null) {
                if (this.queryExprBody instanceof QueryCombined) {
                    colText = Messages._UI_VIEWS_FULLSELECTELEMENT_FULLSELECT;
                } else if (this.queryExprBody instanceof QuerySelect) {
                    colText = Messages._UI_VIEWS_FULLSELECTELEMENT_SELECT;
                } else if (this.queryExprBody instanceof QueryValues) {
                    colText = Messages._UI_VIEWS_FULLSELECTELEMENT_VALUES;
                }
            }
        } else if (columnIndex == 1 && this.operator != null) {
            colText = SelectHelper.getCombinedOperatorSQLString(this.operator.toString());
        }
        return colText;
    }

    public void modify(Object key, Object propValue) {
        QueryStatement stmt;
        if (key == SQLBuilderConstants.P_STATEMENT_OPERATOR && propValue instanceof String && this.operator != null) {
            String value = ((String)propValue).toUpperCase();
            String opString = SelectHelper.getCombinedOperatorStringConstant(value);
            QueryCombinedOperator newOp = QueryCombinedOperator.get((String)opString);
            if (newOp != null) {
                this.operator = newOp;
            }
            this.parent.setCombinedOperator(newOp);
        }
        if ((stmt = StatementHelper.getQueryStatementForTableReference((TableReference)this.parent)) != null) {
            SelectHelper.refresh((SQLQueryObject)stmt);
        }
    }
}

