/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.properties.AbstractPropertyPage;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryProperties;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.ui.security.CredentialsDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class RepositoryPropertyPage
extends AbstractPropertyPage<CDORepository> {
    private static final String USER_ID_LINK_URI = "security:change_login_crendentials";
    private Link userIDLink;

    public RepositoryPropertyPage() {
        super(CDORepositoryProperties.INSTANCE, "Repository", new String[]{"id", "type", "label", "folder"});
    }

    @Override
    protected CDORepository convertElement(IAdaptable element) {
        if (element instanceof CDOCheckout) {
            return ((CDOCheckout)element).getRepository();
        }
        return (CDORepository)AdapterUtil.adapt((Object)element, CDORepository.class);
    }

    @Override
    protected Control createControl(Composite parent, String name, String description, String value) {
        if ("folder".equals(name)) {
            return this.createFileLink(parent, name, description, value);
        }
        if ("authenticating".equals(name)) {
            Button button = new Button(parent, 32);
            button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            button.setSelection(((CDORepository)this.getInput()).isAuthenticating());
            button.setEnabled(false);
            return button;
        }
        if ("userID".equals(name)) {
            this.userIDLink = this.createLink(parent, value, USER_ID_LINK_URI, uri -> this.changeLoginCrendentials());
            this.userIDLink.setToolTipText("Change login credentials");
            return this.userIDLink;
        }
        return super.createControl(parent, name, description, value);
    }

    private void changeLoginCrendentials() {
        CDORepositoryImpl repository = (CDORepositoryImpl)this.getInput();
        String realm = repository.getURI();
        IPasswordCredentials credentials = repository.getCredentials();
        String currentUserID = credentials == null ? null : credentials.getUserID();
        ChangeCredentialsDialog dialog = new ChangeCredentialsDialog(this.getShell(), realm, currentUserID);
        if (dialog.open() == 0) {
            ArrayList<CDOCheckout> openCheckouts = null;
            boolean connected = repository.isConnected();
            if (connected) {
                try {
                    openCheckouts = new ArrayList<CDOCheckout>();
                    CDOCheckout[] cDOCheckoutArray = repository.getCheckouts();
                    int n = cDOCheckoutArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CDOCheckout checkout = cDOCheckoutArray[n2];
                        if (checkout.isOpen()) {
                            openCheckouts.add(checkout);
                        }
                        ++n2;
                    }
                    repository.disconnect(true);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            IPasswordCredentials newCredentials = dialog.getCredentials();
            this.setLinkText(this.userIDLink, newCredentials.getUserID(), USER_ID_LINK_URI);
            repository.setCredentials(newCredentials);
            if (connected) {
                try {
                    repository.connect();
                    if (repository.isConnected() && openCheckouts != null) {
                        for (CDOCheckout checkout : openCheckouts) {
                            checkout.open();
                        }
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }

    private static final class ChangeCredentialsDialog
    extends CredentialsDialog {
        private final String currentUserID;

        public ChangeCredentialsDialog(Shell shell, String realm, String currentUserID) {
            super(shell, realm, "Change Login Credentials", "Enter your user ID and password for the connection.");
            this.currentUserID = currentUserID;
        }

        protected String getInitialUserID() {
            if (!StringUtil.isEmpty((String)this.currentUserID)) {
                return this.currentUserID;
            }
            return super.getInitialUserID();
        }

        protected List<String> loadUsers() {
            HashSet<String> userIDs = new HashSet<String>(super.loadUsers());
            if (!StringUtil.isEmpty((String)this.currentUserID)) {
                userIDs.add(this.currentUserID);
            }
            ArrayList<String> result = new ArrayList<String>(userIDs);
            result.sort(null);
            return result;
        }
    }
}

