/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.patterns;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.examples.filesystem.ui.FilesystemPredefinedColoredAreas;
import org.eclipse.graphiti.examples.mm.filesystem.File;
import org.eclipse.graphiti.examples.mm.filesystem.FilesystemFactory;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.IPattern;
import org.eclipse.graphiti.pattern.id.IdLayoutContext;
import org.eclipse.graphiti.pattern.id.IdPattern;
import org.eclipse.graphiti.pattern.id.IdUpdateContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public class FilePattern
extends IdPattern
implements IPattern {
    private static final String ID_NAME_TEXT = "nameText";
    private static final String ID_OUTER_RECTANGLE = "outerRectangle";
    private static final String ID_MAIN_RECTANGLE = "mainRectangle";

    public String getCreateName() {
        return "File";
    }

    public boolean isMainBusinessObjectApplicable(Object mainBusinessObject) {
        return mainBusinessObject instanceof File;
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        File newFile = FilesystemFactory.eINSTANCE.createFile();
        newFile.setName(this.createNewName());
        this.getDiagram().eResource().getContents().add((Object)newFile);
        this.addGraphicalRepresentation((IAreaContext)context, newFile);
        return new Object[]{newFile};
    }

    public boolean canAdd(IAddContext context) {
        return super.canAdd(context) && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement doAdd(IAddContext context) {
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        File addedDomainObject = (File)context.getNewObject();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaService gaService = Graphiti.getGaService();
        ContainerShape outerContainerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        Rectangle outerRectangle = gaService.createInvisibleRectangle((PictogramElement)outerContainerShape);
        this.setId((PropertyContainer)outerRectangle, ID_OUTER_RECTANGLE);
        gaService.setLocationAndSize((GraphicsAlgorithm)outerRectangle, context.getX(), context.getY(), context.getWidth(), context.getHeight());
        RoundedRectangle registerRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)outerRectangle, 5, 5);
        gaService.setLocationAndSize((GraphicsAlgorithm)registerRectangle, 0, 0, 20, 20);
        registerRectangle.setFilled(Boolean.valueOf(true));
        gaService.setRenderingStyle((AbstractStyle)registerRectangle, FilesystemPredefinedColoredAreas.getGreenWhiteAdaptions());
        Rectangle mainRectangle = gaService.createRectangle((GraphicsAlgorithmContainer)outerRectangle);
        this.setId((PropertyContainer)mainRectangle, ID_MAIN_RECTANGLE);
        mainRectangle.setFilled(Boolean.valueOf(true));
        gaService.setRenderingStyle((AbstractStyle)mainRectangle, FilesystemPredefinedColoredAreas.getGreenWhiteAdaptions());
        Shape shape = peCreateService.createShape(outerContainerShape, false);
        Text text = gaService.createText((GraphicsAlgorithmContainer)shape, addedDomainObject.getName());
        this.setId((PropertyContainer)text, ID_NAME_TEXT);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        peCreateService.createChopboxAnchor((AnchorContainer)outerContainerShape);
        this.link((PictogramElement)outerContainerShape, addedDomainObject);
        this.link((PictogramElement)shape, addedDomainObject);
        return outerContainerShape;
    }

    protected boolean layout(IdLayoutContext context, String id) {
        boolean changesDone = false;
        Rectangle outerRectangle = (Rectangle)context.getRootPictogramElement().getGraphicsAlgorithm();
        if (id.equals(ID_MAIN_RECTANGLE) || id.equals(ID_NAME_TEXT)) {
            GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
            Graphiti.getGaService().setLocationAndSize(ga, 0, 10, outerRectangle.getWidth(), outerRectangle.getHeight() - 10);
            changesDone = true;
        }
        return changesDone;
    }

    protected IReason updateNeeded(IdUpdateContext context, String id) {
        if (id.equals(ID_NAME_TEXT)) {
            Text nameText = (Text)context.getGraphicsAlgorithm();
            File domainObject = (File)context.getDomainObject();
            if (domainObject.getName() == null || !domainObject.getName().equals(nameText.getValue())) {
                return Reason.createTrueReason((String)("Name differs. Expected: '" + domainObject.getName() + "'"));
            }
        }
        return Reason.createFalseReason();
    }

    protected boolean update(IdUpdateContext context, String id) {
        if (id.equals(ID_NAME_TEXT)) {
            Text nameText = (Text)context.getGraphicsAlgorithm();
            File domainObject = (File)context.getDomainObject();
            nameText.setValue(domainObject.getName());
            return true;
        }
        return false;
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        Object domainObject = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        return domainObject instanceof File && ga instanceof Text;
    }

    public String getInitialValue(IDirectEditingContext context) {
        File file = (File)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return file.getName();
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        if (value == null || value.length() == 0) {
            return "File name must not be empty";
        }
        File file = (File)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        EList children = this.getDiagram().getChildren();
        for (Shape child : children) {
            Object domainObject = this.getBusinessObjectForPictogramElement((PictogramElement)child);
            if (!(domainObject instanceof File) || domainObject.equals(file) || !value.equals(((File)domainObject).getName())) continue;
            return "A file with name '" + ((File)domainObject).getName() + "' already exists.";
        }
        return null;
    }

    public void setValue(String value, IDirectEditingContext context) {
        File file = (File)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        file.setName(value);
        this.updatePictogramElement(context.getPictogramElement());
    }

    private String createNewName() {
        String initialName = "NewFile";
        Object name = initialName;
        int number = 0;
        while (this.findFile((String)name) != null) {
            name = initialName + ++number;
        }
        return name;
    }

    private File findFile(String name) {
        EList contents = this.getDiagram().eResource().getContents();
        for (EObject eObject : contents) {
            if (!(eObject instanceof File) || !name.equals(((File)eObject).getName())) continue;
            return (File)eObject;
        }
        return null;
    }
}

