/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.Writer;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.GcConfig;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_Gc")
class Gc
extends TextBuiltin {
    @Option(name="--aggressive", usage="usage_Aggressive")
    private boolean aggressive;
    @Option(name="--preserve-oldpacks", usage="usage_PreserveOldPacks")
    private Boolean preserveOldPacks;
    @Option(name="--prune-preserved", usage="usage_PrunePreserved")
    private Boolean prunePreserved;
    @Option(name="--pack-kept-objects", usage="usage_PackKeptObjects")
    private Boolean packKeptObjects;
    @Option(name="--pack-refs", forbids={"--no-pack-refs"}, usage="usage_GcPackRefs")
    private Boolean packRefs;

    Gc() {
    }

    @Option(name="--no-pack-refs", forbids={"--pack-refs"}, usage="usage_GcNoPackRefs")
    void noPackRefs(boolean ignored) {
        this.packRefs = Boolean.FALSE;
    }

    @Override
    protected void run() {
        Git git = Git.wrap((Repository)this.db);
        try {
            GarbageCollectCommand command = git.gc().setAggressive(this.aggressive).setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)this.errw));
            if (this.preserveOldPacks != null) {
                command.setPreserveOldPacks(this.preserveOldPacks.booleanValue());
            }
            if (this.prunePreserved != null) {
                command.setPrunePreserved(this.prunePreserved.booleanValue());
            }
            if (this.packKeptObjects != null) {
                command.setPackKeptObjects(this.packKeptObjects.booleanValue());
            }
            if (this.packRefs != null) {
                command.setGcConfig(new GcConfig(this.packRefs != false ? GcConfig.PackRefsMode.TRUE : GcConfig.PackRefsMode.FALSE));
            }
            command.call();
        }
        catch (GitAPIException e) {
            throw Gc.die(e.getMessage(), (Throwable)e);
        }
    }
}

