/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.widgets;

import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SpringConfigComposite
extends Composite {
    private CXFContext context = CXFCorePlugin.getDefault().getJava2WSContext();
    private Button useCXFServletButton;
    private Button useSpringAppContextButton;

    public SpringConfigComposite(Composite parent, int style) {
        super(parent, style);
        this.addControls();
    }

    private void addControls() {
        GridLayout preflayout = new GridLayout(1, true);
        this.setLayout((Layout)preflayout);
        GridData gridData = new GridData(4, 4, true, false);
        this.setLayoutData(gridData);
        Group springConfigGroup = new Group((Composite)this, 4);
        springConfigGroup.setText(CXFUIMessages.SPRING_CONFIG_GROUP_LABEL);
        GridLayout springConfigLayout = new GridLayout(2, true);
        springConfigGroup.setLayout((Layout)springConfigLayout);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        springConfigGroup.setLayoutData((Object)gridData);
        this.useCXFServletButton = new Button((Composite)springConfigGroup, 16);
        this.useCXFServletButton.setText(CXFUIMessages.SPRING_CONFIG_USE_CXF_SERVLET);
        this.useCXFServletButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                SpringConfigComposite.this.context.setUseSpringApplicationContext(!selected);
            }
        });
        this.useSpringAppContextButton = new Button((Composite)springConfigGroup, 16);
        this.useSpringAppContextButton.setText(CXFUIMessages.SPRING_CONFIG_USE_CXF_SPRING_APPLICATION_CONTEXT);
        this.useSpringAppContextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                SpringConfigComposite.this.context.setUseSpringApplicationContext(selected);
            }
        });
        if (this.context.isUseSpringApplicationContext()) {
            this.useSpringAppContextButton.setSelection(true);
        } else {
            this.useCXFServletButton.setSelection(true);
        }
    }

    public void setDefaults() {
        boolean useSpringAppcontext = CXFModelUtils.getDefaultBooleanValue((int)0, (int)9);
        this.useSpringAppContextButton.setSelection(useSpringAppcontext);
        this.useCXFServletButton.setSelection(!useSpringAppcontext);
    }

    public void storeValues() {
        this.context.setUseSpringApplicationContext(this.useSpringAppContextButton.getSelection());
    }
}

