/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.util;

import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.ui.internal.util.M2EErrorDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class M2EUIUtils {
    public static Font deriveFont(Font f, int style, int height) {
        FontData[] fd = f.getFontData();
        FontData[] newFD = new FontData[fd.length];
        int i = 0;
        while (i < fd.length) {
            newFD[i] = new FontData(fd[i].getName(), height, style);
            ++i;
        }
        return new Font((Device)Display.getCurrent(), newFD);
    }

    public static void showErrorDialog(Shell shell, String title, String msg, Exception e) {
        StringBuilder buff = new StringBuilder(msg);
        Throwable t = M2EUtils.getRootCause((Throwable)e);
        if (t != null && !M2EUIUtils.nullOrEmpty(t.getMessage())) {
            buff.append(t.getMessage());
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)buff.toString());
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static void showErrorsForProjectsDialog(Shell shell, String title, String message, Map<String, Throwable> errorMap) {
        Display.getDefault().asyncExec(() -> {
            String[] buttons = new String[]{IDialogConstants.OK_LABEL};
            int ok_button = 0;
            M2EErrorDialog errDialog = new M2EErrorDialog(shell, title, Dialog.getImage((String)"dialog_message_error_image"), message, 1, buttons, ok_button, errorMap);
            errDialog.create();
            errDialog.open();
        });
    }

    public static void addRequiredDecoration(Control control) {
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
        ControlDecoration controlDecoration = new ControlDecoration(control, 0x1004000);
        controlDecoration.setDescriptionText(fieldDecoration.getDescription());
        controlDecoration.setImage(fieldDecoration.getImage());
    }
}

