/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.executionviewer.view;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.atl.profiler.core.ATLModelHandler;
import org.eclipse.m2m.atl.profiler.core.ATLProfiler;
import org.eclipse.m2m.atl.profiler.core.ProfilerModelHandler;
import org.eclipse.m2m.atl.profiler.model.Context;
import org.eclipse.m2m.atl.profiler.model.ExecutionError;
import org.eclipse.m2m.atl.profiler.model.ProfilingModel;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;
import org.eclipse.m2m.atl.profiler.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.m2m.atl.profiler.ui.Messages;
import org.eclipse.m2m.atl.profiler.ui.activators.ExecutionViewerActivator;
import org.eclipse.m2m.atl.profiler.ui.executionviewer.view.CallsViewContentProvider;
import org.eclipse.m2m.atl.profiler.ui.executionviewer.view.CallsViewLabelProvider;
import org.eclipse.m2m.atl.profiler.ui.executionviewer.view.ExecutionViewContentProvider;
import org.eclipse.m2m.atl.profiler.ui.executionviewer.view.ExecutionViewLabelProvider;
import org.eclipse.m2m.atl.profiler.ui.executionviewer.view.InstructionFilter;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.ProfilingDataTableView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class ExecutionView
extends ViewPart
implements Observer,
ISelectionListener {
    public static final String ID = "org.eclipse.m2m.atl.profiler.ui.executionviewer.view.ExecutionView";
    private static final String QUICKINFO_ERROR = Messages.getString("ExecutionView_PROFILER_ERROR");
    private static final String SUMMARY_INFO = Messages.getString("ExecutionView_SUMMARY");
    private static boolean showCallTree;
    private static final String SHOW_EXECUTION_SUMMARY_LABEL;
    private static final String SUMMARY_ACTION_ICON = "summaryAction.gif";
    private static final String SHOW_RESOLVE_CONTEXT_ICON = "showResolveContext.gif";
    private static final String EXECUTION_VIEW_ICON = "executionView.gif";
    private static final String CALL_VIEW_ICON = "callView.gif";
    private static final String ATL_PROFILER_QUICK_INFO;
    private static final String SWITCH_ICON = "switch.gif";
    private static final String ATL_PROFILER_CALLS_VIEW;
    private static final String ATL_PROFILER_EXECUTION_VIEW;
    private static final String SWITCH_LABEL;
    private static final String HIDE_HELPER_ICON = "hideHelper.gif";
    private static final String HIDE_ASM_INSTRUCTIONS;
    private static boolean showResolvContextInlabel;
    private TreeViewer treeViewer;
    private DrillDownAdapter drillDownAdapter;
    private Action hideSimpleInstructionsAction;
    private InstructionFilter instructionFilter;
    private Action switchToCallTreeAction;
    private Action doubleClickAction;
    private Action summaryInfoAction;
    private Action putResolveContextInLabelAction;

    static {
        SHOW_EXECUTION_SUMMARY_LABEL = Messages.getString("ExecutionView_SHOW_SUMMARY");
        ATL_PROFILER_QUICK_INFO = Messages.getString("ExecutionView_QUICK_INFO");
        ATL_PROFILER_CALLS_VIEW = Messages.getString("ExecutionView_CALLS_VIEW");
        ATL_PROFILER_EXECUTION_VIEW = Messages.getString("ExecutionView_EXECUTION_VIEW");
        SWITCH_LABEL = Messages.getString("ExecutionView_SWITCH_VIEW");
        HIDE_ASM_INSTRUCTIONS = Messages.getString("ExecutionView_HIDE_ASM");
    }

    public ExecutionView() {
        ATLProfiler.getInstance().addObserver((Observer)this);
        showResolvContextInlabel = true;
    }

    public void dispose() {
        super.dispose();
        ATLProfiler.getInstance().deleteObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.treeViewer);
        this.executionViewProviders();
        this.makeFilters();
        this.hookDoubleClickAction();
        this.makeActions();
        this.setDefaultActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    private void executionViewProviders() {
        this.treeViewer.setContentProvider((IContentProvider)new ExecutionViewContentProvider((AdapterFactory)new ModelItemProviderAdapterFactory()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ExecutionViewLabelProvider((AdapterFactory)new ModelItemProviderAdapterFactory()));
    }

    private void callsViewProviders() {
        this.treeViewer.setContentProvider((IContentProvider)new CallsViewContentProvider((AdapterFactory)new ModelItemProviderAdapterFactory()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CallsViewLabelProvider((AdapterFactory)new ModelItemProviderAdapterFactory()));
    }

    private void showQuickSummary() {
        ProfilerModelHandler modelHandler = ProfilerModelHandler.getInstance();
        ProfilingModel pop = modelHandler.getProfilingModel();
        String message = "";
        if (pop != null) {
            message = String.valueOf(message) + Messages.getString("ExecutionView_TOTAL_INSTRUCTIONS") + modelHandler.getModelTotalInstructions();
            message = String.valueOf(message) + Messages.getString("ExecutionView_TOTAL_TIME") + modelHandler.getModelTotalTime() + " s";
            double mem = (double)(pop.getMaxMemoryUsage() - pop.getLaunchedMemoryUsage()) / 1000.0;
            message = String.valueOf(message) + Messages.getString("ExecutionView_USED_MEMORY") + mem + " Kb";
        } else {
            message = Messages.getString("ExecutionView_NO_SUMMARY");
        }
        this.showMessage(message, SUMMARY_INFO);
    }

    private void hookDoubleClickAction() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExecutionView.this.doubleClickAction.run();
            }
        });
    }

    private void setDefaultActions() {
        if (ProfilerModelHandler.getInstance().isHasTocreateStep()) {
            this.hideSimpleInstructionsAction.setChecked(true);
        }
        this.putResolveContextInLabelAction.setChecked(true);
        this.treeViewer.addFilter((ViewerFilter)this.instructionFilter);
    }

    private void makeFilters() {
        this.instructionFilter = new InstructionFilter();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        if (ProfilerModelHandler.getInstance().isHasTocreateStep()) {
            manager.add((IAction)this.hideSimpleInstructionsAction);
        }
        manager.add((IAction)this.switchToCallTreeAction);
        manager.add((IAction)this.summaryInfoAction);
        manager.add((IAction)this.putResolveContextInLabelAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        if (ProfilerModelHandler.getInstance().isHasTocreateStep()) {
            manager.add((IAction)this.hideSimpleInstructionsAction);
        }
        manager.add((IAction)this.switchToCallTreeAction);
        manager.add((IAction)this.summaryInfoAction);
        manager.add((IAction)this.putResolveContextInLabelAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        if (ProfilerModelHandler.getInstance().isHasTocreateStep()) {
            this.hideSimpleInstructionsAction = new Action(HIDE_ASM_INSTRUCTIONS, 2){

                public void run() {
                    ExecutionView.this.updateFilters(ExecutionView.this.hideSimpleInstructionsAction);
                }
            };
            this.hideSimpleInstructionsAction.setImageDescriptor(ExecutionViewerActivator.getImageDescriptor(HIDE_HELPER_ICON));
        }
        this.switchToCallTreeAction = new Action(SWITCH_LABEL, 2){

            public void run() {
                if (showCallTree) {
                    showCallTree = false;
                    ExecutionView.this.executionViewProviders();
                    ExecutionView.this.putResolveContextInLabelAction.setEnabled(true);
                    if (ProfilerModelHandler.getInstance().isHasTocreateStep()) {
                        ExecutionView.this.hideSimpleInstructionsAction.setEnabled(true);
                    }
                    ExecutionView.this.putResolveContextInLabelAction.setEnabled(true);
                    ExecutionView.this.summaryInfoAction.setEnabled(true);
                    ExecutionView.this.updateViewName(ATL_PROFILER_EXECUTION_VIEW);
                    ExecutionView.this.updateViewIcon(ExecutionViewerActivator.getImageDescriptor(ExecutionView.EXECUTION_VIEW_ICON));
                } else {
                    showCallTree = true;
                    ExecutionView.this.callsViewProviders();
                    ExecutionView.this.putResolveContextInLabelAction.setEnabled(false);
                    if (ProfilerModelHandler.getInstance().isHasTocreateStep()) {
                        ExecutionView.this.hideSimpleInstructionsAction.setEnabled(false);
                    }
                    ExecutionView.this.putResolveContextInLabelAction.setEnabled(false);
                    ExecutionView.this.summaryInfoAction.setEnabled(false);
                    ExecutionView.this.updateViewName(ATL_PROFILER_CALLS_VIEW);
                    ExecutionView.this.updateViewIcon(ExecutionViewerActivator.getImageDescriptor(ExecutionView.CALL_VIEW_ICON));
                }
                ExecutionView.this.treeViewer.refresh();
            }
        };
        this.switchToCallTreeAction.setImageDescriptor(ExecutionViewerActivator.getImageDescriptor(SWITCH_ICON));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ExecutionView.this.treeViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ProfilingOperation) {
                    ExecutionView.this.showQuickInfo((ProfilingOperation)obj);
                } else if (obj instanceof ExecutionError) {
                    ExecutionView.this.showQuickError((ExecutionError)obj);
                }
            }
        };
        this.summaryInfoAction = new Action(SHOW_EXECUTION_SUMMARY_LABEL){

            public void run() {
                ExecutionView.this.showQuickSummary();
            }
        };
        this.summaryInfoAction.setImageDescriptor(ExecutionViewerActivator.getImageDescriptor(SUMMARY_ACTION_ICON));
        this.putResolveContextInLabelAction = new Action("Show __resolve__ context in label", 2){

            public void run() {
                if (showResolvContextInlabel) {
                    showResolvContextInlabel = false;
                } else {
                    showResolvContextInlabel = true;
                }
                ExecutionView.this.treeViewer.refresh();
            }
        };
        this.putResolveContextInLabelAction.setImageDescriptor(ExecutionViewerActivator.getImageDescriptor(SHOW_RESOLVE_CONTEXT_ICON));
    }

    private void showQuickInfo(ProfilingOperation pop) {
        if (!showCallTree) {
            String message = "";
            message = String.valueOf(message) + Messages.getString("ExecutionView_OPERATION") + pop.getContent() + "\n";
            message = ATLModelHandler.isNativeOperation((String)pop.getContent()) ? String.valueOf(message) + Messages.getString("ExecutionView_NATIVE_OPERATION") : String.valueOf(message) + Messages.getString("ExecutionView_ATL_ELEMENT") + pop.getAtlInstruction().getName() + "\n\n";
            double time = (double)(pop.getEndTime() - pop.getLaunchedTime()) / 1000.0;
            message = String.valueOf(message) + Messages.getString("ExecutionView_EXECUTION_TIME") + time + "s \n";
            message = String.valueOf(message) + Messages.getString("ExecutionView_EXECUTED_INSTRUCTIONS") + pop.getExecutionInstructions() + "\n";
            double memStart = (double)pop.getLaunchedMemoryUsage() / 1000.0;
            double memEnd = (double)pop.getEndMemoryUsage() / 1000.0;
            message = String.valueOf(message) + Messages.getString("ExecutionView_LAUNCH_MEMORY") + memStart + " kb \n";
            message = String.valueOf(message) + Messages.getString("ExecutionView_END_MEMORY") + memEnd + " Kb \n";
            if (pop.isHasError()) {
                int nbErrors = pop.getExecutionErrors().size();
                if (nbErrors > 0) {
                    message = String.valueOf(message) + "\n" + nbErrors + " Errors : \n";
                    for (ExecutionError execErr : pop.getExecutionErrors()) {
                        message = String.valueOf(message) + execErr.getMessage() + "\n";
                    }
                } else {
                    message = String.valueOf(message) + "\nErrors in sub operations \n";
                }
            }
            message = String.valueOf(message) + "\nContext : ";
            for (Context c : pop.getContext()) {
                message = String.valueOf(message) + c.getContent() + "\n";
            }
            this.showMessage(message, ATL_PROFILER_QUICK_INFO);
        }
    }

    private void showQuickError(ExecutionError obj) {
        if (!showCallTree) {
            String message = "";
            message = String.valueOf(message) + obj.getMessage();
            message = String.valueOf(message) + "\n\nContext : \n";
            message = String.valueOf(message) + obj.getFrames();
            message = String.valueOf(message) + "\n\nError : \n";
            message = String.valueOf(message) + obj.getError();
            this.showMessage(message, QUICKINFO_ERROR);
        }
    }

    private void showMessage(String message, String title) {
        MessageDialog.openInformation((Shell)this.treeViewer.getControl().getShell(), (String)title, (String)message);
    }

    private void updateViewName(String name) {
        this.setPartName(name);
    }

    private void updateViewIcon(ImageDescriptor image) {
        this.setTitleImage(image.createImage());
    }

    private void updateFilters(Action updateFiltersAction) {
        if (updateFiltersAction.isChecked()) {
            this.treeViewer.addFilter((ViewerFilter)this.instructionFilter);
        } else {
            this.treeViewer.removeFilter((ViewerFilter)this.instructionFilter);
        }
        this.treeViewer.refresh();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setInput(final Object arg) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionView.this.treeViewer.setInput(arg);
                ExecutionView.this.treeViewer.refresh();
                ExecutionView.this.showQuickSummary();
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setInput(arg);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TreeSelection current;
        if (part instanceof ProfilingDataTableView && !ExecutionView.isShowCallTree() && (current = (TreeSelection)selection).getFirstElement() instanceof ProfilingOperation) {
            this.treeViewer.setSelection((ISelection)current);
        }
    }

    public static boolean isShowCallTree() {
        return showCallTree;
    }

    public static boolean isShowResolvContextInlabel() {
        return showResolvContextInlabel;
    }
}

