/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.jsp.generation.files;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.java.generation.utils.IndentingStringBuilder;
import org.eclipse.modisco.jee.jsp.JspPackage;
import org.eclipse.modisco.jee.jsp.util.JspSwitch;
import org.eclipse.modisco.xml.Attribute;
import org.eclipse.modisco.xml.CDATA;
import org.eclipse.modisco.xml.Comment;
import org.eclipse.modisco.xml.DocumentTypeDeclaration;
import org.eclipse.modisco.xml.Element;
import org.eclipse.modisco.xml.Namespace;
import org.eclipse.modisco.xml.Node;
import org.eclipse.modisco.xml.ProcessingInstruction;
import org.eclipse.modisco.xml.Root;
import org.eclipse.modisco.xml.Text;
import org.eclipse.modisco.xml.emf.MoDiscoXMLPackage;
import org.eclipse.modisco.xml.emf.util.MoDiscoXMLSwitch;

public class JspModel2JspTextUtils
extends JspSwitch<Object> {
    private DelegatingXMLSwitch xmlSwitch = new DelegatingXMLSwitch();
    private IndentingStringBuilder indentingStringBuilder = null;
    private Map<String, String> file2text = new HashMap<String, String>();
    public static Map<String, Integer> eClassName2coverage = null;

    protected void append(boolean value) {
        this.append(Boolean.toString(value));
    }

    protected void append(String string) {
        this.indentingStringBuilder.append(string);
    }

    protected void appendEndLine() {
        this.indentingStringBuilder.appendEndLine();
    }

    protected boolean appendNode(EObject jNode) {
        int classifierID;
        if (jNode == null) {
            return false;
        }
        EClass eClass = jNode.eClass();
        EObject eContainer = eClass.eContainer();
        if (eContainer == JspPackage.eINSTANCE) {
            classifierID = eClass.getClassifierID();
            this.doSwitch(classifierID, jNode);
        } else if (eContainer == MoDiscoXMLPackage.eINSTANCE) {
            classifierID = eClass.getClassifierID();
            this.xmlSwitch.doSwitch(classifierID, jNode);
        } else {
            this.doSwitch(eClass, jNode);
        }
        if (eClassName2coverage != null) {
            String eClassName = eClass.getName();
            eClassName2coverage.put(eClassName, eClassName2coverage.getOrDefault(eClassName, 0) + 1);
        }
        return true;
    }

    protected void appendNodes(List<? extends EObject> jNodes) {
        for (EObject eObject : jNodes) {
            this.appendNode(eObject);
        }
    }

    protected void appendOptionalWrappedNodes(String prefix, List<? extends EObject> jNodes, String separator, String suffix) {
        if (jNodes.size() > 0) {
            this.appendWrappedNodes(prefix, jNodes, separator, suffix);
        }
    }

    protected void appendRaw(String string) {
        this.indentingStringBuilder.appendRaw(string);
    }

    protected void appendSoftNewLine() {
        this.indentingStringBuilder.appendSoftNewLine();
    }

    protected void appendSoftSpace() {
        this.indentingStringBuilder.appendSoftSpace();
    }

    protected boolean appendWrappedNode(String prefix, EObject jNode, String suffix) {
        if (jNode == null) {
            return false;
        }
        this.append(prefix);
        this.appendNode(jNode);
        this.append(suffix);
        return true;
    }

    protected void appendWrappedNodes(String prefix, List<? extends EObject> jNodes, String separator, String suffix) {
        this.append(prefix);
        String nextSeparator = null;
        for (EObject eObject : jNodes) {
            this.append(nextSeparator);
            this.appendNode(eObject);
            nextSeparator = separator;
        }
        this.append(suffix);
    }

    protected void doChildren(EObject jObject, boolean withIndentation) {
        if (withIndentation) {
            this.pushIndentation();
        }
        for (EObject eChild : jObject.eContents()) {
            this.appendNode((EObject)((Node)eChild));
        }
        if (withIndentation) {
            this.popIndentation();
        }
    }

    public Map<String, String> generate(Iterable<Resource> resources) {
        for (Resource resource : resources) {
            for (EObject eObject : resource.getContents()) {
                this.appendNode(eObject);
            }
        }
        return this.file2text;
    }

    public void popFile(String fileKey) {
        this.indentingStringBuilder.close();
        this.file2text.put(fileKey, this.indentingStringBuilder.toString());
        this.indentingStringBuilder = null;
    }

    protected void popIndentation() {
        this.indentingStringBuilder.popIndentation();
    }

    public void pushFile() {
        assert (this.indentingStringBuilder == null);
        this.indentingStringBuilder = new IndentingStringBuilder();
    }

    protected void pushIndentation() {
        this.indentingStringBuilder.pushIndentation();
    }

    public String toString() {
        return this.indentingStringBuilder.toString();
    }

    public Object caseXmlAttribute(Attribute object) {
        return null;
    }

    public Object caseXmlCDATA(CDATA object) {
        return null;
    }

    public Object caseXmlElement(Element object) {
        return null;
    }

    public Object caseXmlComment(Comment object) {
        return null;
    }

    public Object caseXmlDocumentTypeDeclaration(DocumentTypeDeclaration object) {
        return null;
    }

    public Object caseXmlNamespace(Namespace object) {
        return null;
    }

    public Object caseXmlNode(Node object) {
        return null;
    }

    public Object caseXmlProcessingInstruction(ProcessingInstruction object) {
        return null;
    }

    public Object caseXmlRoot(Root object) {
        return null;
    }

    public Object caseXmlText(Text object) {
        return null;
    }

    public final class DelegatingXMLSwitch
    extends MoDiscoXMLSwitch {
        public Object caseAttribute(Attribute object) {
            return JspModel2JspTextUtils.this.caseXmlAttribute(object);
        }

        public Object caseCDATA(CDATA object) {
            return JspModel2JspTextUtils.this.caseXmlCDATA(object);
        }

        public Object caseElement(Element object) {
            return JspModel2JspTextUtils.this.caseXmlElement(object);
        }

        public Object caseComment(Comment object) {
            return JspModel2JspTextUtils.this.caseXmlComment(object);
        }

        public Object caseDocumentTypeDeclaration(DocumentTypeDeclaration object) {
            return JspModel2JspTextUtils.this.caseXmlDocumentTypeDeclaration(object);
        }

        public Object caseNamespace(Namespace object) {
            return JspModel2JspTextUtils.this.caseXmlNamespace(object);
        }

        public Object caseNode(Node object) {
            return JspModel2JspTextUtils.this.caseXmlNode(object);
        }

        public Object caseProcessingInstruction(ProcessingInstruction object) {
            return JspModel2JspTextUtils.this.caseXmlProcessingInstruction(object);
        }

        public Object caseRoot(Root object) {
            return JspModel2JspTextUtils.this.caseXmlRoot(object);
        }

        public Object caseText(Text object) {
            return JspModel2JspTextUtils.this.caseXmlText(object);
        }

        public Object defaultCase(EObject object) {
            return JspModel2JspTextUtils.this.defaultCase(object);
        }

        public Object doSwitch(int classifierID, EObject theEObject) {
            return super.doSwitch(classifierID, theEObject);
        }
    }
}

