/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;

public class BorderNodeCollapseManager {
    private Rectangle collapsedRectangle;

    public Rectangle expandCollapsedNodeBounds(IBorderItemEditPart hostEditPart, PrecisionRectangle rect) {
        IBorderItemLocator borderItemLocator;
        if (this.isCollapsed((IGraphicalEditPart)hostEditPart) && (borderItemLocator = hostEditPart.getBorderItemLocator()) instanceof DBorderItemLocator) {
            if (this.collapsedRectangle == null) {
                this.collapsedRectangle = ((DBorderItemLocator)borderItemLocator).getCurrentConstraint();
            }
            EditPart parentEditPart = hostEditPart.getParent();
            Rectangle parentBounds = null;
            if (parentEditPart instanceof IGraphicalEditPart) {
                IFigure parentFigure = ((IGraphicalEditPart)parentEditPart).getFigure();
                parentBounds = parentFigure.getBounds().getCopy();
                if (parentFigure instanceof NodeFigure) {
                    parentBounds = ((NodeFigure)parentFigure).getHandleBounds().getCopy();
                }
                Dimension initialDim = this.getInitialDimension((IGraphicalEditPart)hostEditPart);
                Rectangle newBoundsAbsolute = PortLayoutHelper.getUncollapseCandidateLocation(initialDim, (Rectangle)rect, parentBounds);
                Rectangle newBoundsFromFigure = PortLayoutHelper.getUncollapseCandidateLocation(initialDim, this.collapsedRectangle, null);
                borderItemLocator.setConstraint(newBoundsFromFigure);
                ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                return newBoundsAbsolute;
            }
        }
        return null;
    }

    public boolean isCollapsed(IGraphicalEditPart editPart) {
        EObject element = editPart.resolveSemanticElement();
        if (element instanceof DDiagramElement) {
            DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)element);
            return query.isIndirectlyCollapsed();
        }
        return false;
    }

    public void restoreCollapsedNode(IBorderItemEditPart borderItemEP) {
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator instanceof DBorderItemLocator) {
            borderItemLocator.setConstraint(this.collapsedRectangle.getCopy());
            ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
        }
    }

    public Dimension getInitialDimension(IGraphicalEditPart editPart) {
        Object node = editPart.getModel();
        if (node instanceof Node) {
            NodeQuery query = new NodeQuery((Node)node);
            return query.getOriginalDimensionBeforeCollapse();
        }
        return new Dimension(0, 0);
    }

    public void dispose() {
        this.collapsedRectangle = null;
    }

    public Rectangle getCollapsedRectangle() {
        return this.collapsedRectangle;
    }

    public boolean hasBeenExpanded() {
        return this.collapsedRectangle != null;
    }
}

