/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.ValMessages;

public final class Misc {
    public static void close(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public static void close(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static boolean debugOptionAsBoolean(String option) {
        String opt = Platform.getDebugOption((String)option);
        if (opt == null) {
            return false;
        }
        if ("true".equals(opt = opt.toLowerCase())) {
            return true;
        }
        return "yes".equals(opt);
    }

    public static String getTimeNano(long time) {
        if (time <= 1000L) {
            return NLS.bind((String)ValMessages.TimeNano, (Object)time);
        }
        if (time <= 1000000L) {
            return NLS.bind((String)ValMessages.TimeMicro, (Object)(time / 1000L));
        }
        return Misc.getTimeMS(time / 1000000L);
    }

    public static long getCPUTime() {
        long cpuTime = -1L;
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        if (tb.isCurrentThreadCpuTimeSupported()) {
            cpuTime = tb.getCurrentThreadCpuTime();
        }
        return cpuTime;
    }

    public static String getTimeMS(long time) {
        if (time <= 1000L) {
            return ValMessages.TimeUnder;
        }
        if (time <= 60000L) {
            return NLS.bind((String)ValMessages.TimeSec, (Object)(time / 1000L));
        }
        return NLS.bind((String)ValMessages.TimeMin, (Object)(time / 60000L));
    }

    public static String listMarkers(IResource resource) {
        StringBuffer b = new StringBuffer(2000);
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers(null, true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                Object o = m.getAttribute("message");
                if (o != null) {
                    b.append(o);
                }
                if ((o = m.getAttribute("severity")) != null) {
                    b.append(", Severity=");
                    b.append(o);
                }
                b.append("; ");
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return b.toString();
    }

    public static boolean same(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static void niy(String msg) {
        if (msg == null) {
            msg = "Sorry, this function is not implemented yet";
        }
        throw new RuntimeException(msg);
    }

    public static String resourceChangeEventType(int type) {
        StringBuffer b = new StringBuffer(200);
        if ((type & 0x10) != 0) {
            b.append("post_build ");
        }
        if ((type & 1) != 0) {
            b.append("post_change ");
        }
        if ((type & 8) != 0) {
            b.append("pre_build ");
        }
        if ((type & 2) != 0) {
            b.append("pre_close ");
        }
        if ((type & 4) != 0) {
            b.append("pre_delete ");
        }
        return b.toString();
    }
}

