/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.console.EclipseJavacPatternMatcher;
import org.eclipse.ant.internal.ui.console.JavacMarkerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public abstract class AbstractJavacPatternMatcher
implements IPatternMatchListenerDelegate {
    protected TextConsole fConsole;
    private static Pattern fgLineNumberPattern = Pattern.compile("\\d+");
    private static List<AbstractJavacPatternMatcher> fgPatternMatchers = new ArrayList<AbstractJavacPatternMatcher>();
    private Map<String, IFile> fFileNameToIFile = new HashMap<String, IFile>();
    private JavacMarkerCreator fMarkerCreator;
    protected static final Integer fgWarningType = new Integer(1);
    protected static final Integer fgErrorType = new Integer(2);

    public void connect(TextConsole console) {
        this.fConsole = console;
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("createMarkers")) {
            this.fMarkerCreator = new JavacMarkerCreator(this.fConsole, this instanceof EclipseJavacPatternMatcher);
            fgPatternMatchers.add(this);
        }
    }

    public void disconnect() {
        this.fConsole = null;
        this.fFileNameToIFile.clear();
    }

    protected IFile getIFile(String filePath) {
        IFile[] files;
        if (filePath == null) {
            return null;
        }
        IFile file = this.fFileNameToIFile.get(filePath);
        if (file == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new Path(filePath).toFile().toURI())).length > 0) {
            file = files[0];
            this.fFileNameToIFile.put(filePath, file);
        }
        return file;
    }

    protected String getMatchedText(PatternMatchEvent event) {
        int eventOffset = event.getOffset();
        int eventLength = event.getLength();
        IDocument document = this.fConsole.getDocument();
        String matchedText = null;
        try {
            matchedText = document.get(eventOffset, eventLength);
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
        return matchedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLineNumber(int eventOffset, boolean sameLine) {
        IDocument document = this.fConsole.getDocument();
        try {
            int fileLine = document.getLineOfOffset(eventOffset);
            if (!sameLine) {
                ++fileLine;
            }
            IRegion region = document.getLineInformation(fileLine);
            int regionLength = region.getLength();
            if (region.getOffset() != eventOffset) {
                regionLength -= eventOffset - region.getOffset();
            }
            String lineLine = document.get(eventOffset, regionLength);
            Matcher matcher = null;
            Pattern pattern = fgLineNumberPattern;
            synchronized (pattern) {
                matcher = fgLineNumberPattern.matcher(lineLine);
            }
            if (matcher.find()) {
                String lineString = matcher.group();
                return Integer.parseInt(lineString);
            }
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
        catch (NumberFormatException e) {
            AntUIPlugin.log(e);
        }
        return -1;
    }

    protected void addLink(String filePath, int lineNumber, int offset, int length, Integer type) {
        IFile file = this.getIFile(filePath);
        if (file == null) {
            return;
        }
        if (this.fMarkerCreator != null) {
            if (type == null) {
                this.fMarkerCreator.addFileToBeCleaned(file);
            } else {
                this.fMarkerCreator.addMarker(file, lineNumber, offset, type);
            }
        }
        FileLink link = new FileLink(file, null, -1, -1, lineNumber);
        try {
            this.fConsole.addHyperlink((IHyperlink)link, offset, length);
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
    }

    public static void consoleClosed(IProcess process) {
        for (AbstractJavacPatternMatcher matcher : fgPatternMatchers) {
            matcher.finished(process);
        }
    }

    protected void finished(IProcess process) {
        if (this.fMarkerCreator != null) {
            this.fMarkerCreator.finished(process);
            fgPatternMatchers.remove(this);
        }
    }
}

