/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalID;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTFieldReference
extends ASTNode
implements ICPPASTFieldReference,
IASTAmbiguityParent,
ICPPASTCompletionContext {
    private boolean fIsTemplate;
    private boolean fIsDeref;
    private ICPPASTExpression fOwner;
    private IASTName fName;
    private IASTImplicitName[] fImplicitNames;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTFieldReference() {
    }

    public CPPASTFieldReference(IASTName name, IASTExpression owner) {
        this.setFieldName(name);
        this.setFieldOwner(owner);
    }

    @Override
    public CPPASTFieldReference copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTFieldReference copy(IASTNode.CopyStyle style) {
        CPPASTFieldReference copy = new CPPASTFieldReference();
        copy.setFieldName(this.fName == null ? null : this.fName.copy(style));
        copy.setFieldOwner(this.fOwner == null ? null : this.fOwner.copy(style));
        copy.fIsTemplate = this.fIsTemplate;
        copy.fIsDeref = this.fIsDeref;
        return this.copy(copy, style);
    }

    @Override
    public boolean isTemplate() {
        return this.fIsTemplate;
    }

    @Override
    public void setIsTemplate(boolean value) {
        this.assertNotFrozen();
        this.fIsTemplate = value;
    }

    @Override
    public ICPPASTExpression getFieldOwner() {
        return this.fOwner;
    }

    @Override
    public void setFieldOwner(IASTExpression expression) {
        this.assertNotFrozen();
        this.fOwner = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FIELD_OWNER);
        }
    }

    @Override
    public IASTName getFieldName() {
        return this.fName;
    }

    @Override
    public void setFieldName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(FIELD_NAME);
        }
    }

    @Override
    public boolean isPointerDereference() {
        return this.fIsDeref;
    }

    @Override
    public void setIsPointerDereference(boolean value) {
        this.assertNotFrozen();
        this.fIsDeref = value;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            if (!this.fIsDeref) {
                this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            ArrayList<ICPPFunction> functionBindings = new ArrayList<ICPPFunction>();
            EvalMemberAccess.getFieldOwnerType(this.fOwner.getExpressionType(), this.fIsDeref, this, functionBindings, false);
            if (functionBindings.isEmpty()) {
                this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            this.fImplicitNames = new IASTImplicitName[functionBindings.size()];
            int i = -1;
            for (ICPPFunction op : functionBindings) {
                if (op == null || op instanceof CPPImplicitFunction) continue;
                CPPASTImplicitName operatorName = new CPPASTImplicitName(OverloadableOperator.ARROW, (IASTNode)this);
                operatorName.setBinding(op);
                operatorName.computeOperatorOffsets(this.fOwner, true);
                this.fImplicitNames[++i] = operatorName;
            }
            this.fImplicitNames = ArrayUtil.trimAt(IASTImplicitName.class, this.fImplicitNames, i);
        }
        return this.fImplicitNames;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fOwner != null && !this.fOwner.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTFieldReference.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.fName) {
            return 1;
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fOwner) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fOwner = (ICPPASTExpression)other;
        }
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        int j = 0;
        int i = 0;
        while (i < bindings.length) {
            IBinding binding = bindings[i];
            if (!(binding instanceof ICPPMethod) || !((ICPPMethod)binding).isImplicit()) {
                if (i != j) {
                    bindings[j] = binding;
                }
                ++j;
            }
            ++i;
        }
        if (j < bindings.length) {
            return Arrays.copyOfRange(bindings, 0, j);
        }
        return bindings;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }

    @Override
    public IType getFieldOwnerType() {
        return EvalMemberAccess.getFieldOwnerType(this.fOwner.getExpressionType(), this.fIsDeref, this, null, true);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.createEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation createEvaluation() {
        IType ownerType;
        ICPPEvaluation ownerEval = this.fOwner.getEvaluation();
        if (!ownerEval.isTypeDependent() && (ownerType = EvalMemberAccess.getFieldOwnerType(ownerEval.getType(this), this.fIsDeref, this, null, false)) != null) {
            IBinding binding = this.fName.resolvePreBinding();
            if (binding instanceof CPPFunctionSet) {
                binding = this.fName.resolveBinding();
            }
            if (binding instanceof IProblemBinding || binding instanceof IType || binding instanceof ICPPConstructor) {
                return EvalFixed.INCOMPLETE;
            }
            return new EvalMemberAccess(ownerType, ownerEval.getValueCategory(this), binding, ownerEval, this.fIsDeref, this);
        }
        IBinding qualifier = null;
        ICPPTemplateArgument[] args = null;
        IASTName n = this.fName;
        if (n instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qn = (ICPPASTQualifiedName)n;
            ICPPASTNameSpecifier[] ns = qn.getQualifier();
            if (ns.length < 1) {
                return EvalFixed.INCOMPLETE;
            }
            qualifier = ns[ns.length - 1].resolveBinding();
            if (qualifier instanceof IProblemBinding) {
                return EvalFixed.INCOMPLETE;
            }
            n = qn.getLastName();
        }
        if (n instanceof ICPPASTTemplateId) {
            try {
                args = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)n);
            }
            catch (DOMException e) {
                return EvalFixed.INCOMPLETE;
            }
        }
        return new EvalID(ownerEval, qualifier, this.fName.getSimpleID(), false, true, this.fIsDeref, args, this);
    }

    public static int getFieldPosition(ICPPField field) {
        ICPPClassType ownerType = field.getClassOwner();
        if (ownerType == null) {
            return -1;
        }
        ICPPClassType[] baseClasses = ClassTypeHelper.getAllBases(ownerType, null);
        int baseFields = 0;
        ICPPClassType[] iCPPClassTypeArray = baseClasses;
        int n = baseClasses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType baseClass = iCPPClassTypeArray[n2];
            baseFields += ClassTypeHelper.getDeclaredFields(baseClass, null).length;
            ++n2;
        }
        return baseFields + field.getFieldPosition();
    }

    public static int getFieldPosition(IBinding binding, IType ownerType) {
        IType nestedType = SemanticUtil.getNestedType(ownerType, 16);
        if (nestedType instanceof ICPPClassType && binding instanceof ICPPField) {
            ICPPField field = (ICPPField)binding;
            return CPPASTFieldReference.getFieldPosition(field);
        }
        return -1;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }
}

