/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.core.runtime.CoreException;

public final class EvalPointer
extends EvalReference {
    private int position;

    public EvalPointer(ActivationRecord record, EvalCompositeAccess referredSubValue, IASTNode point) {
        this(record, referredSubValue, EvalPointer.findEnclosingTemplate(point));
    }

    public EvalPointer(ActivationRecord record, EvalCompositeAccess referredSubValue, IBinding templateDefinition) {
        this(record, referredSubValue, templateDefinition, referredSubValue.getElementId());
    }

    public EvalPointer(ActivationRecord record, EvalCompositeAccess referredSubValue, IBinding templateDefinition, int offset) {
        super(record, referredSubValue, templateDefinition);
        this.setPosition(offset);
    }

    public EvalPointer(ActivationRecord record, IBinding referredBinding, IBinding templateDefinition) {
        super(record, referredBinding, templateDefinition);
        this.setPosition(0);
    }

    public EvalReference dereference() {
        if (this.referredSubValue != null) {
            EvalCompositeAccess pointedToValue = new EvalCompositeAccess(this.referredSubValue.getParent(), this.getPosition());
            return new EvalReference(this.owningRecord, pointedToValue, this.getTemplateDefinition());
        }
        return new EvalReference(this.owningRecord, this.referredBinding, this.getTemplateDefinition());
    }

    @Override
    public IType getType(IASTNode point) {
        IType valueType = this.getTargetEvaluation().getType(point);
        return new CPPPointerType(valueType, false, false, false);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        this.invalidatePointerIfPositionOutOfRange();
    }

    private void invalidatePointerIfPositionOutOfRange() {
        if (this.isPositionOutOfRange()) {
            this.referredSubValue = new EvalCompositeAccess(EvalFixed.INCOMPLETE, 0);
            this.referredBinding = null;
        }
    }

    private boolean isPositionOutOfRange() {
        return this.subValuePositionOutOfrange() || this.referredBinding != null && this.position != 0;
    }

    private boolean subValuePositionOutOfrange() {
        return this.referredSubValue != null && (this.position - this.referredSubValue.getParent().getValue(null).numberOfSubValues() > 0 || this.position < 0);
    }

    @Override
    public IValue getValue(IASTNode point) {
        return IntegralValue.create(this.position);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this;
    }

    public EvalPointer copy() {
        if (this.referredSubValue != null) {
            return new EvalPointer(this.owningRecord, this.referredSubValue, this.getTemplateDefinition(), this.position);
        }
        return new EvalPointer(this.owningRecord, this.referredBinding, this.getTemplateDefinition());
    }

    public static EvalPointer createFromAddress(EvalReference reference) {
        if (reference.referredSubValue != null) {
            return new EvalPointer(reference.owningRecord, reference.referredSubValue, reference.getTemplateDefinition());
        }
        return new EvalPointer(reference.owningRecord, reference.referredBinding, reference.getTemplateDefinition());
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 19;
        if (this.referredSubValue != null) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
        if (this.referredSubValue != null) {
            buffer.marshalEvaluation(this.referredSubValue, includeValue);
            buffer.putInt(this.position);
        } else {
            buffer.marshalBinding(this.referredBinding);
            buffer.marshalEvaluation(this.owningRecord.getVariable(this.referredBinding), includeValue);
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean subValue;
        boolean bl = subValue = (firstBytes & 0x20) != 0;
        if (subValue) {
            EvalCompositeAccess referredSubValue = (EvalCompositeAccess)buffer.unmarshalEvaluation();
            int position = buffer.getInt();
            IBinding templateDefinition = buffer.unmarshalBinding();
            return new EvalPointer(new ActivationRecord(), referredSubValue, templateDefinition, position);
        }
        IBinding referredBinding = buffer.unmarshalBinding();
        ICPPEvaluation value = buffer.unmarshalEvaluation();
        ActivationRecord record = new ActivationRecord();
        record.update(referredBinding, value);
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalPointer(record, referredBinding, templateDefinition);
    }
}

