/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers.categories;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractSideRelatedDifferenceCategory;
import org.eclipse.swt.graphics.Image;

public class UnmatchedElementCategory
extends AbstractSideRelatedDifferenceCategory {
    public static final String ID_LEFT = "Technical.Unmatched.Left";
    public static final String ID_RIGHT = "Technical.Unmatched.Right";

    public UnmatchedElementCategory(boolean sideIsLeft_p) {
        super(sideIsLeft_p);
    }

    public boolean covers(IDifference difference_p, EMFDiffNode node_p) {
        boolean result = false;
        if (difference_p instanceof IElementPresence) {
            IElementPresence presence = (IElementPresence)difference_p;
            Role sideRole = node_p.getRoleForSide(this.isLeftSide());
            result = presence.getPresenceRole() == sideRole;
        }
        return result;
    }

    public String getDescription(EMFDiffNode node_p) {
        String result = this.isLeftSide() ? Messages.UnmatchedElementCategory_DescriptionLeft : Messages.UnmatchedElementCategory_DescriptionRight;
        return result;
    }

    public String getID() {
        return this.isLeftSide() ? ID_LEFT : ID_RIGHT;
    }

    public Image getImage(EMFDiffNode node_p) {
        Role referenceRole = node_p.getReferenceRole();
        Role leftRole = node_p.getRoleForSide(true);
        EMFDiffMergeUIPlugin.ImageID imageID = this.isLeftSide() ? (referenceRole == leftRole ? EMFDiffMergeUIPlugin.ImageID.INC_REM_STAT : EMFDiffMergeUIPlugin.ImageID.OUT_ADD_STAT) : (referenceRole == leftRole.opposite() ? EMFDiffMergeUIPlugin.ImageID.OUT_REM_STAT : EMFDiffMergeUIPlugin.ImageID.INC_ADD_STAT);
        return node_p.getResourceManager().getStandaloneOverlay(imageID);
    }

    public String getText(EMFDiffNode node_p) {
        String result = this.isLeftSide() ? Messages.UnmatchedElementCategory_TextLeft : Messages.UnmatchedElementCategory_TextRight;
        return result;
    }
}

