/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class ParameterizedSQLBatchWritingMechanism
extends BatchWritingMechanism {
    protected DatabaseCall previousCall;
    protected List<List> parameters;
    protected DatabaseCall lastCallAppended;

    public ParameterizedSQLBatchWritingMechanism() {
    }

    public ParameterizedSQLBatchWritingMechanism(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.parameters = new ArrayList<List>();
        this.maxBatchSize = this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize();
        if (this.maxBatchSize == 0) {
            this.maxBatchSize = DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE;
        }
    }

    @Override
    public void appendCall(AbstractSession session, DatabaseCall dbCall) {
        if (dbCall.hasParameters()) {
            if (this.previousCall == null) {
                this.previousCall = dbCall;
                this.parameters.add(dbCall.getParameters());
            } else if (this.previousCall.getSQLString().equals(dbCall.getSQLString()) && this.parameters.size() < this.maxBatchSize) {
                this.parameters.add(dbCall.getParameters());
            } else {
                this.executeBatchedStatements(session);
                this.previousCall = dbCall;
                this.parameters.add(dbCall.getParameters());
            }
            if (dbCall != null) {
                this.cacheQueryTimeout(session, dbCall);
            }
            this.lastCallAppended = dbCall;
            if (((ModifyQuery)dbCall.getQuery()).forceBatchStatementExecution()) {
                this.executeBatchedStatements(session);
            }
        } else {
            this.executeBatchedStatements(session);
            this.switchMechanisms(session, dbCall);
        }
    }

    @Override
    public void clear() {
        this.previousCall = null;
        this.parameters = new ArrayList<List>();
        this.statementCount = 0;
        this.executionCount = 0;
        this.queryTimeoutCache = 0;
        this.lastCallAppended = null;
    }

    @Override
    public void executeBatchedStatements(AbstractSession session) {
        if (this.parameters.isEmpty()) {
            return;
        }
        ParameterizedSQLBatchWritingMechanism currentBatch = (ParameterizedSQLBatchWritingMechanism)this.clone();
        this.clear();
        currentBatch.executeBatch(session);
    }

    private void executeBatch(AbstractSession session) {
        if (this.parameters.size() == 1) {
            try {
                int rowCount = (Integer)this.databaseAccessor.basicExecuteCall(this.previousCall, null, session, false);
                if (this.previousCall.hasOptimisticLock() && rowCount != 1) {
                    throw OptimisticLockException.batchStatementExecutionFailure();
                }
            }
            finally {
                this.clear();
            }
            return;
        }
        try {
            this.databaseAccessor.incrementCallCount(session);
            if (session.shouldLog(3, "sql")) {
                session.log(2, "sql", "begin_batch_statements", null, this.databaseAccessor);
                session.log(3, "sql", this.previousCall.getSQLString(), null, this.databaseAccessor, false);
                for (List callParameters : this.parameters) {
                    StringWriter writer = new StringWriter();
                    DatabaseCall.appendLogParameters(callParameters, this.databaseAccessor, writer, session);
                    session.log(3, "sql", writer.toString(), null, this.databaseAccessor, false);
                }
                session.log(2, "sql", "end_batch_statements", null, this.databaseAccessor);
            }
            PreparedStatement statement = this.prepareBatchStatements(session);
            this.executionCount += this.databaseAccessor.executeJDK12BatchStatement(statement, this.lastCallAppended, session, true);
            ++this.databaseAccessor.writeStatementsCount;
            if (this.previousCall.hasOptimisticLock() && this.executionCount != this.statementCount) {
                throw OptimisticLockException.batchStatementExecutionFailure();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void switchMechanisms(AbstractSession session, DatabaseCall dbCall) {
        this.databaseAccessor.setActiveBatchWritingMechanismToDynamicSQL();
        this.databaseAccessor.getActiveBatchWritingMechanism(session).appendCall(session, dbCall);
    }

    protected PreparedStatement prepareBatchStatements(AbstractSession session) throws DatabaseException {
        PreparedStatement statement = null;
        try {
            session.startOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            try {
                org.eclipse.persistence.platform.database.DatabasePlatform platform = session.getPlatform();
                boolean shouldUnwrapConnection = platform.usesNativeBatchWriting();
                statement = (PreparedStatement)this.databaseAccessor.prepareStatement(this.previousCall, session, shouldUnwrapConnection);
                platform.prepareBatchStatement(statement, this.maxBatchSize);
                if (this.queryTimeoutCache > 0) {
                    statement.setQueryTimeout(this.queryTimeoutCache);
                }
                int statementSize = this.parameters.size();
                int statementIndex = 0;
                while (statementIndex < statementSize) {
                    List parameterList = this.parameters.get(statementIndex);
                    int size = parameterList.size();
                    int index = 0;
                    while (index < size) {
                        platform.setParameterValueInDatabaseCall(parameterList.get(index), statement, index + 1, session);
                        ++index;
                    }
                    ++this.statementCount;
                    this.executionCount += platform.addBatch(statement);
                    ++statementIndex;
                }
            }
            finally {
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            }
        }
        catch (SQLException exception) {
            DatabaseException exceptionToThrow = this.databaseAccessor.processExceptionForCommError(session, exception, this.lastCallAppended);
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {}
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, this.databaseAccessor, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {}
            throw exception;
        }
        return statement;
    }

    public DatabaseCall getPreviousCall() {
        return this.previousCall;
    }

    public void setPreviousCall(DatabaseCall previousCall) {
        this.previousCall = previousCall;
    }

    public List<List> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<List> parameters) {
        this.parameters = parameters;
    }

    public DatabaseCall getLastCallAppended() {
        return this.lastCallAppended;
    }

    public void setLastCallAppended(DatabaseCall lastCallAppended) {
        this.lastCallAppended = lastCallAppended;
    }
}

