/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event.lookup;

import java.util.Objects;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;

public class CtfTmfCallsite
extends TmfCallsite {
    private final String fEventName;
    private final long fInstructionPointer;

    public CtfTmfCallsite(CTFCallsite callsite) {
        super(callsite.getFileName(), Long.valueOf(callsite.getLineNumber()));
        this.fEventName = callsite.getEventName();
        this.fInstructionPointer = callsite.getIp();
    }

    public String getEventName() {
        return this.fEventName;
    }

    public long getIntructionPointer() {
        return this.fInstructionPointer;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fEventName == null ? 0 : this.fEventName.hashCode());
        result = 31 * result + (int)(this.fInstructionPointer ^ this.fInstructionPointer >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CtfTmfCallsite other = (CtfTmfCallsite)((Object)obj);
        if (!Objects.equals(this.fEventName, other.fEventName)) {
            return false;
        }
        return this.fInstructionPointer == other.fInstructionPointer;
    }

    public String toString() {
        return String.valueOf(this.getEventName()) + "@0x" + Long.toHexString(this.fInstructionPointer) + ": " + this.getFileName() + ':' + String.valueOf(this.getLineNo()) + ' ' + this.getFileName() + "()";
    }
}

