/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import java.text.Format;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartTooltipProvider;
import org.swtchart.IAxisTick;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class TmfCommonXLineChartViewer
extends TmfXYChartViewer {
    private static final double DEFAULT_MAXY = Double.MIN_VALUE;
    private static final double DEFAULT_MINY = Double.MAX_VALUE;
    private static final double RESOLUTION = 1.0;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfCommonXLineChartViewer.class);
    private static final int[] LINE_COLORS = new int[]{9, 3, 5, 11, 13, 10, 4, 6, 12, 14, 8, 2, 15};
    private static final LineStyle[] LINE_STYLES = new LineStyle[]{LineStyle.SOLID, LineStyle.DASH, LineStyle.DOT, LineStyle.DASHDOT};
    private final Map<String, double[]> fSeriesValues = new LinkedHashMap<String, double[]>();
    private double[] fXValues;
    private double fResolution;
    private UpdateThread fUpdateThread;
    private final AtomicInteger fDirty = new AtomicInteger();

    public TmfCommonXLineChartViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title, xLabel, yLabel);
        this.getSwtChart().getTitle().setVisible(false);
        this.getSwtChart().getLegend().setPosition(1024);
        this.getSwtChart().getAxisSet().getXAxes()[0].getTitle().setVisible(false);
        this.setResolution(1.0);
        this.setTooltipProvider(new TmfCommonXLineChartTooltipProvider(this));
    }

    protected void setResolution(double resolution) {
        this.fResolution = resolution;
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.reinitialize();
    }

    private @NonNull String getViewerId() {
        return this.getClass().getName();
    }

    private Runnable newUiInitializeRunnable(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog enclosingScope) {
        return () -> {
            block12: {
                Throwable throwable = null;
                Object var3_4 = null;
                try (TraceCompassLogUtils.FlowScopeLog uiScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UiInitialization", new Object[0]).setParentScope(enclosingScope).build();){
                    if (this.getSwtChart().isDisposed()) break block12;
                    try {
                        this.clearContent();
                        this.createSeries();
                    }
                    finally {
                        this.fDirty.decrementAndGet();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        };
    }

    private Runnable newIntializeRunnable(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog scope) {
        return () -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (TraceCompassLogUtils.FlowScopeLog tracer = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:InitializeThread", new Object[0]).setParentScope(scope).build();){
                this.initializeDataSource();
                if (!this.getSwtChart().isDisposed()) {
                    TmfCommonXLineChartViewer.getDisplay().asyncExec(this.newUiInitializeRunnable(tracer));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
    }

    protected void reinitialize() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ReinitializeRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fSeriesValues.clear();
            this.fDirty.incrementAndGet();
            Thread thread = new Thread(this.newIntializeRunnable(scope));
            thread.start();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void initializeDataSource() {
    }

    private synchronized void newUpdateThread(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog fScope) {
        this.cancelUpdate();
        if (!this.getSwtChart().isDisposed()) {
            int numRequests = (int)((double)this.getSwtChart().getPlotArea().getBounds().width * this.fResolution);
            this.fUpdateThread = new UpdateThread(numRequests, fScope);
            this.fUpdateThread.start();
        }
    }

    private synchronized void updateThreadFinished(UpdateThread thread) {
        if (thread == this.fUpdateThread) {
            this.fUpdateThread = null;
        }
    }

    protected synchronized void cancelUpdate() {
        if (this.fUpdateThread != null) {
            this.fUpdateThread.cancel();
        }
    }

    @Override
    protected void updateContent() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog parentScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ContentUpdateRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fDirty.incrementAndGet();
            TmfCommonXLineChartViewer.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:CreatingUpdateThread", new Object[0]).setParentScope(parentScope).build();){
                        TmfCommonXLineChartViewer.this.newUpdateThread(scope);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static final double[] getXAxis(long start, long end, int nb) {
        long steps = end - start;
        int nbVals = nb;
        if (steps < (long)nb && (nbVals = (int)steps) <= 0) {
            nbVals = 1;
        }
        double step = (double)steps / (double)nbVals;
        double[] timestamps = new double[nbVals];
        double curTime = 1.0;
        int i = 0;
        while (i < nbVals) {
            timestamps[i] = curTime;
            curTime += step;
            ++i;
        }
        return timestamps;
    }

    protected final void setXAxis(double[] xaxis) {
        this.fXValues = xaxis;
    }

    protected abstract void updateData(long var1, long var3, int var5, IProgressMonitor var6);

    protected void setSeries(String seriesName, double[] seriesValues) {
        if (this.fXValues.length != seriesValues.length) {
            throw new IllegalStateException("All series in list must be of length : " + this.fXValues.length);
        }
        this.fSeriesValues.put(seriesName, seriesValues);
    }

    protected ILineSeries addSeries(String seriesName) {
        ISeriesSet seriesSet = this.getSwtChart().getSeriesSet();
        int seriesCount = seriesSet.getSeries().length;
        ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
        series.setVisible(true);
        series.enableArea(false);
        series.setLineStyle(LINE_STYLES[seriesCount / LINE_COLORS.length % LINE_STYLES.length]);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setLineColor(Display.getDefault().getSystemColor(LINE_COLORS[seriesCount % LINE_COLORS.length]));
        return series;
    }

    protected void deleteSeries(String seriesName) {
        ISeries series = this.getSwtChart().getSeriesSet().getSeries(seriesName);
        if (series != null) {
            this.getSwtChart().getSeriesSet().deleteSeries(series.getId());
        }
        this.fSeriesValues.remove(seriesName);
    }

    protected void updateDisplay() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateDisplayRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fDirty.incrementAndGet();
            Display.getDefault().asyncExec(new Runnable(){
                final TmfChartTimeStampFormat tmfChartTimeStampFormat;
                {
                    this.tmfChartTimeStampFormat = new TmfChartTimeStampFormat(TmfCommonXLineChartViewer.this.getTimeOffset());
                }

                @Override
                public void run() {
                    try {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateDisplay", new Object[0]).setParentScope(scope).build();){
                            if (!TmfCommonXLineChartViewer.this.getSwtChart().isDisposed()) {
                                double[] xValues = TmfCommonXLineChartViewer.this.fXValues;
                                double maxy = Double.MIN_VALUE;
                                double miny = Double.MAX_VALUE;
                                for (Map.Entry entry : TmfCommonXLineChartViewer.this.fSeriesValues.entrySet()) {
                                    ILineSeries series = (ILineSeries)TmfCommonXLineChartViewer.this.getSwtChart().getSeriesSet().getSeries((String)entry.getKey());
                                    if (series == null) {
                                        series = TmfCommonXLineChartViewer.this.addSeries((String)entry.getKey());
                                    }
                                    series.setXSeries(xValues);
                                    double[] dArray = (double[])entry.getValue();
                                    int n = dArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        double value = dArray[n2];
                                        maxy = Math.max(maxy, value);
                                        miny = Math.min(miny, value);
                                        ++n2;
                                    }
                                    series.setYSeries((double[])entry.getValue());
                                }
                                if (maxy == Double.MIN_VALUE) {
                                    maxy = 1.0;
                                }
                                IAxisTick xTick = TmfCommonXLineChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).getTick();
                                xTick.setFormat((Format)this.tmfChartTimeStampFormat);
                                double start = 0.0;
                                double end = TmfCommonXLineChartViewer.this.getWindowEndTime() - TmfCommonXLineChartViewer.this.getWindowStartTime();
                                TmfCommonXLineChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).setRange(new Range(0.0, end));
                                if (maxy > miny) {
                                    TmfCommonXLineChartViewer.this.getSwtChart().getAxisSet().getYAxis(0).setRange(new Range(miny, maxy));
                                }
                                TmfCommonXLineChartViewer.this.getSwtChart().redraw();
                                if (TmfCommonXLineChartViewer.this.isSendTimeAlignSignals()) {
                                    Point viewPos = TmfCommonXLineChartViewer.this.getParent().getParent().toDisplay(0, 0);
                                    int axisPos = ((TmfCommonXLineChartViewer)TmfCommonXLineChartViewer.this).getSwtChart().toDisplay((int)0, (int)0).x + TmfCommonXLineChartViewer.this.getPointAreaOffset();
                                    int timeAxisOffset = axisPos - viewPos.x;
                                    TmfTimeViewAlignmentInfo timeAlignmentInfo = new TmfTimeViewAlignmentInfo(TmfCommonXLineChartViewer.this.getControl().getShell(), viewPos, timeAxisOffset);
                                    TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(TmfCommonXLineChartViewer.this, timeAlignmentInfo, true));
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        TmfCommonXLineChartViewer.this.fDirty.decrementAndGet();
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createSeries() {
    }

    @Override
    protected void clearContent() {
        this.getSwtChart().getAxisSet().getXAxis(0).getTick().setFormat(null);
        super.clearContent();
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.fDirty.get() != 0;
    }

    private class UpdateThread
    extends Thread {
        private final IProgressMonitor fMonitor;
        private final int fNumRequests;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public UpdateThread(@NonNull int numRequests, TraceCompassLogUtils.FlowScopeLog log) {
            super("Line chart update");
            this.fNumRequests = numRequests;
            this.fMonitor = new NullProgressMonitor();
            this.fScope = log;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateThread", new Object[]{"numRequests=", this.fNumRequests}).setParentScope(this.fScope).build();){
                try {
                    TmfCommonXLineChartViewer.this.updateData(TmfCommonXLineChartViewer.this.getWindowStartTime(), TmfCommonXLineChartViewer.this.getWindowEndTime(), this.fNumRequests, this.fMonitor);
                }
                finally {
                    TmfCommonXLineChartViewer.this.fDirty.decrementAndGet();
                }
                TmfCommonXLineChartViewer.this.updateThreadFinished(this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void cancel() {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"CommonXLineChart:UpdateThreadCanceled", (Object[])new Object[0]);
            this.fMonitor.setCanceled(true);
        }
    }
}

