/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.AbstractShare;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ecf.core.Messages;
import org.eclipse.team.internal.ecf.core.TeamSynchronization;
import org.eclipse.team.internal.ecf.core.messages.FetchResponse;
import org.eclipse.team.internal.ecf.core.messages.FetchVariantRequest;
import org.eclipse.team.internal.ecf.core.messages.FetchVariantsRequest;
import org.eclipse.team.internal.ecf.core.messages.IResponse;
import org.eclipse.team.internal.ecf.core.messages.ShareRequest;
import org.eclipse.team.internal.ecf.core.messages.ShareResponse;
import org.eclipse.team.internal.ecf.core.variants.RemoteResourceVariant;

public class RemoteShare
extends AbstractShare {
    private Map participants = new HashMap();
    private Object returnValue;

    public RemoteShare(IChannelContainerAdapter adapter) throws ECFException {
        super(adapter);
    }

    public synchronized boolean sendShareRequest(ID localId, ID remoteId, IResource[] resources, IProgressMonitor monitor) throws ECFException, InterruptedException {
        Assert.isNotNull((Object)localId);
        Assert.isNotNull((Object)remoteId);
        Assert.isNotNull((Object)resources);
        this.sendMessage(remoteId, RemoteShare.serialize(new ShareRequest(localId, resources)));
        while (this.returnValue == null) {
            Thread.sleep(100L);
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        Object tmpValue = this.returnValue;
        this.returnValue = null;
        return (Boolean)tmpValue;
    }

    public synchronized IResourceVariant[] fetchMembers(ID ownId, ID remoteId, IResourceVariant variant, IProgressMonitor monitor) throws TeamException {
        RemoteResourceVariant remoteVariant = (RemoteResourceVariant)variant;
        if (!remoteVariant.hasMembers()) {
            return new IResourceVariant[0];
        }
        monitor.subTask(NLS.bind((String)Messages.RemoteShare_FetchingVariant, (Object)variant.getName()));
        this.sendMessage(remoteId, new FetchVariantsRequest(ownId, remoteVariant.getPath(), remoteVariant.getType()));
        while (this.returnValue == null) {
            try {
                Thread.sleep(100L);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new TeamException("Interrupted whilst fetching members");
            }
        }
        monitor.done();
        Object tmpValue = this.returnValue;
        this.returnValue = null;
        return (IResourceVariant[])tmpValue;
    }

    public synchronized IResourceVariant fetchVariant(ID ownId, ID remoteId, IResource resource, IProgressMonitor monitor) throws TeamException {
        monitor.subTask(NLS.bind((String)Messages.RemoteShare_FetchingVariant, (Object)resource.getFullPath().toString().substring(1)));
        this.sendMessage(remoteId, new FetchVariantRequest(ownId, resource.getFullPath().toString(), resource.getType()));
        while (this.returnValue == null) {
            try {
                Thread.sleep(100L);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new TeamException("Interrupted whilst fetching variant");
            }
        }
        monitor.done();
        Object tmpValue = this.returnValue;
        this.returnValue = null;
        return ((IResourceVariant[])tmpValue)[0];
    }

    public synchronized IResourceVariant getResourceVariant(ID ownId, ID remoteId, IResource resource) throws TeamException {
        this.sendMessage(remoteId, new FetchVariantRequest(ownId, resource.getFullPath().toString(), resource.getType()));
        while (this.returnValue == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new TeamException("Interrupted whilst getting variant");
            }
        }
        Object tmpValue = this.returnValue;
        this.returnValue = null;
        return ((IResourceVariant[])tmpValue)[0];
    }

    private void sendMessage(ID id, Serializable serializable) {
        try {
            this.sendMessage(id, RemoteShare.serialize(serializable));
        }
        catch (ECFException e) {
            TeamSynchronization.log("Could not send message to peer " + id, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleMessage(ID fromContainerId, byte[] data) {
        Object message = RemoteShare.deserialize(data);
        if (message instanceof FetchVariantsRequest) {
            FetchVariantRequest msg = (FetchVariantRequest)message;
            String path = msg.getPath();
            IFolder container = null;
            switch (msg.getType()) {
                case 1: {
                    TeamSynchronization.log("Files should not have any variants to request for");
                    break;
                }
                case 4: {
                    container = ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(path).lastSegment());
                    break;
                }
                case 2: {
                    container = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(path));
                    break;
                }
                default: {
                    TeamSynchronization.log("Unsupported resource type specified: " + msg.getType());
                }
            }
            this.sendFetchVariantsResponse(msg.getFromId(), (IContainer)container);
            return;
        }
        if (message instanceof FetchVariantRequest) {
            FetchVariantRequest msg = (FetchVariantRequest)message;
            IFolder resource = null;
            Path path = new Path(msg.getPath());
            switch (msg.getType()) {
                case 4: {
                    resource = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
                    break;
                }
                case 2: {
                    resource = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                    break;
                }
                case 1: {
                    resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    break;
                }
                default: {
                    TeamSynchronization.log("Unsupported resource type specified: " + msg.getType());
                }
            }
            this.sendFetchVariantResponse(msg.getFromId(), (IResource)resource);
            return;
        }
        if (!(message instanceof ShareRequest)) {
            if (!(message instanceof IResponse)) return;
            this.returnValue = ((IResponse)message).getResponse();
            return;
        }
        ShareRequest request = (ShareRequest)message;
        boolean response = this.prompt(request.getFromId(), request.getPaths());
        if (response) {
            response = false;
            String[] paths = request.getPaths();
            int[] types = request.getTypes();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            block15: while (i < paths.length) {
                switch (types[i]) {
                    case 4: {
                        if (!workspaceRoot.getProject(new Path(paths[i]).lastSegment()).exists()) break;
                        response = true;
                        break block15;
                    }
                    case 2: {
                        if (!workspaceRoot.getFolder((IPath)new Path(paths[i])).exists()) break;
                        response = true;
                        break block15;
                    }
                    case 1: {
                        if (!workspaceRoot.getFile((IPath)new Path(paths[i])).exists()) break;
                        response = true;
                        break block15;
                    }
                }
                ++i;
            }
        }
        this.sendMessage(request.getFromId(), new ShareResponse(response));
    }

    protected boolean prompt(ID fromId, String[] paths) {
        return false;
    }

    private void sendFetchVariantsResponse(ID fromId, IContainer container) {
        if (container == null) {
            this.sendMessage(fromId, new FetchResponse());
            return;
        }
        try {
            IResource[] members = container.members();
            ArrayList<RemoteResourceVariant> variants = new ArrayList<RemoteResourceVariant>();
            int i = 0;
            while (i < members.length) {
                if (!members[i].isDerived()) {
                    variants.add(new RemoteResourceVariant(members[i]));
                }
                ++i;
            }
            IResourceVariant[] variantsArray = variants.toArray(new IResourceVariant[variants.size()]);
            this.sendMessage(fromId, new FetchResponse(variantsArray));
        }
        catch (CoreException e) {
            TeamSynchronization.log("Could not retrieve container members: " + container.getFullPath(), e);
        }
    }

    private void sendFetchVariantResponse(ID fromId, IResource resource) {
        if (resource != null && resource.exists()) {
            this.sendMessage(fromId, new FetchResponse(new RemoteResourceVariant(resource)));
        } else {
            this.sendMessage(fromId, new FetchResponse(null));
        }
    }

    public synchronized void dispose() {
        this.participants.clear();
        super.dispose();
    }

    private static Object deserialize(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream inputStream = new ObjectInputStream(bais);
            return inputStream.readObject();
        }
        catch (IOException e) {
            TeamSynchronization.log("Could not read deserialize data", e);
            return null;
        }
        catch (ClassNotFoundException e) {
            TeamSynchronization.log("Could not find class for deserialization", e);
            return null;
        }
    }

    private static byte[] serialize(Serializable serializable) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(baos);
            outputStream.writeObject(serializable);
            return baos.toByteArray();
        }
        catch (IOException e) {
            TeamSynchronization.log("Could not read serialize object", e);
            return null;
        }
    }
}

