/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteserviceadmin.ui.rsa;

import java.util.List;
import org.eclipse.ecf.internal.remoteservices.ui.DiscoveryComponent;
import org.eclipse.ecf.internal.remoteservices.ui.Messages;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.AbstractRemoteServiceAdminView;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRSAContentProvider;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRSANode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRegistrationNode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.EndpointDescriptionRSANode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ExportRegistrationNode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ExportedServicesRootNode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ImportRegistrationNode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ImportedEndpointsRootNode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.RSAContentProvider;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ServiceIdNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IViewSite;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;

public class RemoteServiceAdminView
extends AbstractRemoteServiceAdminView {
    public static final String ID_VIEW = "org.eclipse.ecf.remoteserviceadmin.ui.views.RSAView";
    private Action closeExportAction;
    private Action closeImportAction;

    @Override
    public void dispose() {
        super.dispose();
        DiscoveryComponent discovery = DiscoveryComponent.getDefault();
        if (discovery != null) {
            discovery.setRSAView(null);
            discovery = null;
        }
    }

    @Override
    protected void updateModel() {
        this.updateModel(0);
    }

    @Override
    protected AbstractRSAContentProvider createContentProvider(IViewSite viewSite) {
        return new RSAContentProvider(viewSite);
    }

    @Override
    protected void setupListeners() {
        DiscoveryComponent.getDefault().setRSAView(this);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        if (selection != null) {
            Object e = selection.getFirstElement();
            if (e instanceof ImportRegistrationNode) {
                manager.add((IAction)this.closeImportAction);
            } else if (e instanceof ExportRegistrationNode) {
                manager.add((IAction)this.closeExportAction);
            }
        }
    }

    @Override
    protected void makeActions() {
        RemoteServiceAdmin rsa = this.getLocalRSA();
        this.closeExportAction = this.createCloseAction();
        this.closeExportAction.setText(Messages.RemoteServiceAdminView_0);
        this.closeExportAction.setEnabled(rsa != null);
        this.closeImportAction = this.createCloseAction();
        this.closeImportAction.setText(Messages.RemoteServiceAdminView_1);
        this.closeImportAction.setEnabled(rsa != null);
    }

    private void updateExports(ExportedServicesRootNode exportedRoot) {
        RemoteServiceAdmin rsa = this.getLocalRSA();
        if (rsa != null && exportedRoot != null) {
            exportedRoot.clearChildren();
            List exportRegistrations = rsa.getExportedRegistrations();
            for (RemoteServiceAdmin.ExportRegistration er : exportRegistrations) {
                ExportRegistrationNode exportRegistrationNode = new ExportRegistrationNode(er);
                RemoteServiceAdmin.ExportReference eRef = (RemoteServiceAdmin.ExportReference)er.getExportReference();
                if (eRef != null) {
                    exportRegistrationNode.addChild(new ServiceIdNode(eRef.getExportedService(), Messages.RSAView_SERVICE_ID_LABEL));
                    EndpointDescription ed = (EndpointDescription)eRef.getExportedEndpoint();
                    if (ed != null) {
                        exportRegistrationNode.addChild(new EndpointDescriptionRSANode(ed));
                    }
                }
                exportedRoot.addChild(exportRegistrationNode);
            }
        }
    }

    private void updateImports(ImportedEndpointsRootNode importedRoot) {
        RemoteServiceAdmin rsa = this.getLocalRSA();
        if (rsa != null && importedRoot != null) {
            importedRoot.clearChildren();
            List importRegistrations = rsa.getImportedRegistrations();
            for (RemoteServiceAdmin.ImportRegistration ir : importRegistrations) {
                ImportRegistrationNode importRegistrationNode = new ImportRegistrationNode(ir);
                RemoteServiceAdmin.ImportReference iRef = (RemoteServiceAdmin.ImportReference)ir.getImportReference();
                if (iRef != null) {
                    importRegistrationNode.addChild(new ServiceIdNode(iRef.getImportedService(), Messages.RSAView_PROXY_SERVICE_ID_LABEL));
                    EndpointDescription ed = (EndpointDescription)iRef.getImportedEndpoint();
                    if (ed != null) {
                        importRegistrationNode.addChild(new EndpointDescriptionRSANode(ed, ir));
                    }
                }
                importedRoot.addChild(importRegistrationNode);
            }
        }
    }

    private ExportedServicesRootNode getExportedServicesRoot() {
        return ((RSAContentProvider)this.contentProvider).getExportedServicesRoot();
    }

    private ImportedEndpointsRootNode getImportedServicesRoot() {
        return ((RSAContentProvider)this.contentProvider).getImportedEndpointsRoot();
    }

    private void updateExports() {
        this.updateExports(this.getExportedServicesRoot());
    }

    private void updateImports() {
        this.updateImports(this.getImportedServicesRoot());
    }

    private void updateModel(final int type) {
        if (this.viewer == null) {
            return;
        }
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                switch (type) {
                    case 0: {
                        RemoteServiceAdminView.this.updateExports();
                        RemoteServiceAdminView.this.updateImports();
                        break;
                    }
                    case 1: {
                        RemoteServiceAdminView.this.updateExports();
                        break;
                    }
                    case 2: {
                        RemoteServiceAdminView.this.updateImports();
                    }
                }
                RemoteServiceAdminView.this.viewer.setExpandedState((Object)RemoteServiceAdminView.this.getExportedServicesRoot(), true);
                RemoteServiceAdminView.this.viewer.setExpandedState((Object)RemoteServiceAdminView.this.getImportedServicesRoot(), true);
                RemoteServiceAdminView.this.viewer.refresh();
            }
        });
    }

    private Action createCloseAction() {
        return new Action(){

            public void run() {
                AbstractRegistrationNode n = RemoteServiceAdminView.this.getSelectedRegistrationNode();
                if (n != null) {
                    n.close();
                }
            }
        };
    }

    private AbstractRegistrationNode getSelectedRegistrationNode() {
        AbstractRSANode aen = this.getSelectedNode();
        return aen instanceof AbstractRegistrationNode ? (AbstractRegistrationNode)aen : null;
    }

    public void handleRSAEvent(final RemoteServiceAdminEvent event) {
        if (this.viewer == null) {
            return;
        }
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RemoteServiceAdmin rsa = RemoteServiceAdminView.this.getLocalRSA();
                if (rsa != null) {
                    switch (event.getType()) {
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 10: {
                            RemoteServiceAdminView.this.updateModel(1);
                            break;
                        }
                        case 1: 
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: {
                            RemoteServiceAdminView.this.updateModel(2);
                        }
                    }
                }
            }
        });
    }
}

